/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.BufferedImageFactory;
import com.twelvemonkeys.image.CopyDither;
import com.twelvemonkeys.image.DiffusionDither;
import com.twelvemonkeys.image.ImageConversionException;
import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.image.InverseColorMapIndexColorModel;
import com.twelvemonkeys.image.MonochromeColorModel;
import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.lang.StringUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;

class IndexImage {
    protected static final int DITHER_MASK = 255;
    public static final int DITHER_DEFAULT = 0;
    public static final int DITHER_NONE = 1;
    public static final int DITHER_DIFFUSION = 2;
    public static final int DITHER_DIFFUSION_ALTSCANS = 3;
    protected static final int COLOR_SELECTION_MASK = 65280;
    public static final int COLOR_SELECTION_DEFAULT = 0;
    public static final int COLOR_SELECTION_FAST = 256;
    public static final int COLOR_SELECTION_QUALITY = 512;
    protected static final int TRANSPARENCY_MASK = 0xFF0000;
    public static final int TRANSPARENCY_DEFAULT = 0;
    public static final int TRANSPARENCY_OPAQUE = 65536;
    public static final int TRANSPARENCY_BITMASK = 131072;
    protected static final int TRANSPARENCY_TRANSLUCENT = 196608;

    private IndexImage() {
    }

    public static IndexColorModel getIndexColorModel(Image pImage, int pNumberOfColors, boolean pFast) {
        return IndexImage.getIndexColorModel(pImage, pNumberOfColors, pFast ? 256 : 512);
    }

    public static IndexColorModel getIndexColorModel(Image pImage, int pNumberOfColors, int pHints) throws ImageConversionException {
        IndexColorModel icm = null;
        RenderedImage image = null;
        if (pImage instanceof RenderedImage) {
            image = (RenderedImage)((Object)pImage);
            ColorModel cm = image.getColorModel();
            if (cm instanceof IndexColorModel && ((IndexColorModel)cm).getMapSize() <= pNumberOfColors) {
                icm = (IndexColorModel)cm;
            }
        } else {
            BufferedImageFactory factory = new BufferedImageFactory(pImage);
            ColorModel cm = factory.getColorModel();
            if (cm instanceof IndexColorModel && ((IndexColorModel)cm).getMapSize() <= pNumberOfColors) {
                icm = (IndexColorModel)cm;
            } else {
                image = factory.getBufferedImage();
            }
        }
        if (icm == null) {
            icm = IndexImage.createIndexColorModel(ImageUtil.toBuffered(image), pNumberOfColors, pHints);
        } else if (!(icm instanceof InverseColorMapIndexColorModel)) {
            icm = new InverseColorMapIndexColorModel(icm);
        }
        return icm;
    }

    private static IndexColorModel createIndexColorModel(BufferedImage pImage, int pNumberOfColors, int pHints) {
        boolean useTransparency = IndexImage.isTransparent(pHints);
        if (useTransparency) {
            --pNumberOfColors;
        }
        int width = pImage.getWidth();
        int height = pImage.getHeight();
        List[] colors = new List[4096];
        int step = 1;
        if (IndexImage.isFast(pHints)) {
            step += width * height / 16384;
        }
        int sampleCount = 0;
        for (int x = 0; x < width; ++x) {
            block1: for (int y = x % step; y < height; y += step) {
                ++sampleCount;
                int rgb = pImage.getRGB(x, y) & 0xFFFFFF;
                int index = (rgb & 0xF00000) >>> 12 | (rgb & 0xF000) >>> 8 | (rgb & 0xF0) >>> 4;
                ArrayList<Counter> v = colors[index];
                if (v == null) {
                    v = new ArrayList<Counter>();
                    v.add(new Counter(rgb));
                    colors[index] = v;
                    continue;
                }
                Iterator i = v.iterator();
                while (i.hasNext()) {
                    if (!((Counter)i.next()).add(rgb)) continue;
                    continue block1;
                }
                v.add(new Counter(rgb));
            }
        }
        int numberOfCubes = 1;
        int fCube = 0;
        Cube[] cubes = new Cube[pNumberOfColors];
        cubes[0] = new Cube(colors, sampleCount);
        while (numberOfCubes < pNumberOfColors) {
            int i;
            while (cubes[fCube].isDone() && ++fCube != numberOfCubes) {
            }
            if (fCube == numberOfCubes) break;
            Cube cube = cubes[fCube];
            Cube newCube = cube.split();
            if (newCube == null) continue;
            if (newCube.count > cube.count) {
                Cube tmp = cube;
                cube = newCube;
                newCube = tmp;
            }
            int j = fCube;
            int count = cube.count;
            for (i = fCube + 1; i < numberOfCubes && cubes[i].count >= count; ++i) {
                cubes[j++] = cubes[i];
            }
            cubes[j++] = cube;
            count = newCube.count;
            while (j < numberOfCubes && cubes[j].count >= count) {
                ++j;
            }
            for (i = numberOfCubes; i > j; --i) {
                cubes[i] = cubes[i - 1];
            }
            cubes[j] = newCube;
            ++numberOfCubes;
        }
        byte[] r = new byte[useTransparency ? numberOfCubes + 1 : numberOfCubes];
        byte[] g = new byte[useTransparency ? numberOfCubes + 1 : numberOfCubes];
        byte[] b = new byte[useTransparency ? numberOfCubes + 1 : numberOfCubes];
        for (int i = 0; i < numberOfCubes; ++i) {
            int val = cubes[i].averageColor();
            r[i] = (byte)(val >> 16 & 0xFF);
            g[i] = (byte)(val >> 8 & 0xFF);
            b[i] = (byte)(val & 0xFF);
        }
        int numOfBits = 8;
        InverseColorMapIndexColorModel icm = useTransparency ? new InverseColorMapIndexColorModel(numOfBits, r.length, r, g, b, r.length - 1) : new InverseColorMapIndexColorModel(numOfBits, r.length, r, g, b);
        return icm;
    }

    public static BufferedImage getIndexedImage(BufferedImage pImage) {
        return IndexImage.getIndexedImage(pImage, 256, 0);
    }

    private static boolean isFast(int pHints) {
        return (pHints & 0xFF00) != 512;
    }

    static boolean isTransparent(int pHints) {
        return (pHints & 0x20000) != 0 || (pHints & 0x30000) != 0;
    }

    public static BufferedImage getIndexedImage(BufferedImage pImage, Image pPalette, Color pMatte, int pHints) throws ImageConversionException {
        return IndexImage.getIndexedImage(pImage, IndexImage.getIndexColorModel(pPalette, 256, pHints), pMatte, pHints);
    }

    public static BufferedImage getIndexedImage(BufferedImage pImage, int pNumberOfColors, Color pMatte, int pHints) {
        IndexColorModel icm = pMatte != null ? IndexImage.getIndexColorModel((Image)IndexImage.createSolid(pImage, pMatte), pNumberOfColors, pHints) : IndexImage.getIndexColorModel((Image)pImage, pNumberOfColors, pHints);
        if ((pHints & 0xFF) != 1 && icm.getMapSize() < pNumberOfColors) {
            pHints = pHints & 0xFFFFFF00 | 1;
        }
        return IndexImage.getIndexedImage(pImage, icm, pMatte, pHints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getIndexedImage(BufferedImage pImage, IndexColorModel pColors, Color pMatte, int pHints) {
        int width = pImage.getWidth();
        int height = pImage.getHeight();
        boolean transparency = IndexImage.isTransparent(pHints) && pImage.getColorModel().getTransparency() != 1 && pColors.getTransparency() != 1;
        BufferedImage solid = pImage;
        if (pMatte != null) {
            solid = IndexImage.createSolid(pImage, pMatte);
        }
        BufferedImage indexed = pColors.getMapSize() > 2 ? new BufferedImage(width, height, 13, pColors) : new BufferedImage(width, height, 12, pColors);
        switch (pHints & 0xFF) {
            case 2: 
            case 3: {
                DiffusionDither dither = new DiffusionDither(pColors);
                if ((pHints & 0xFF) == 3) {
                    dither.setAlternateScans(true);
                }
                dither.filter(solid, indexed);
                break;
            }
            case 1: {
                CopyDither copy = new CopyDither(pColors);
                copy.filter(solid, indexed);
                break;
            }
            default: {
                Graphics2D g2d = indexed.createGraphics();
                try {
                    RenderingHints hints = new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                    g2d.setRenderingHints(hints);
                    g2d.drawImage((Image)solid, 0, 0, null);
                    break;
                }
                finally {
                    g2d.dispose();
                }
            }
        }
        if (transparency) {
            IndexImage.applyAlpha(indexed, pImage);
        }
        return indexed;
    }

    public static BufferedImage getIndexedImage(BufferedImage pImage, int pNumberOfColors, int pHints) {
        return IndexImage.getIndexedImage(pImage, pNumberOfColors, null, pHints);
    }

    public static BufferedImage getIndexedImage(BufferedImage pImage, IndexColorModel pColors, int pHints) {
        return IndexImage.getIndexedImage(pImage, pColors, null, pHints);
    }

    public static BufferedImage getIndexedImage(BufferedImage pImage, Image pPalette, int pHints) {
        return IndexImage.getIndexedImage(pImage, pPalette, null, pHints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage createSolid(BufferedImage pOriginal, Color pBackground) {
        BufferedImage solid = new BufferedImage(pOriginal.getColorModel(), pOriginal.copyData(null), pOriginal.isAlphaPremultiplied(), null);
        Graphics2D g = solid.createGraphics();
        try {
            g.setColor(pBackground);
            g.setComposite(AlphaComposite.DstOver);
            g.fillRect(0, 0, pOriginal.getWidth(), pOriginal.getHeight());
        }
        finally {
            g.dispose();
        }
        return solid;
    }

    private static void applyAlpha(BufferedImage pImage, BufferedImage pAlpha) {
        for (int y = 0; y < pAlpha.getHeight(); ++y) {
            for (int x = 0; x < pAlpha.getWidth(); ++x) {
                if ((pAlpha.getRGB(x, y) >> 24 & 0xFF) >= 64) continue;
                pImage.setRGB(x, y, 0xFFFFFF);
            }
        }
    }

    public static void main(String[] pArgs) {
        long end;
        IndexColorModel colors;
        BufferedImage indexed;
        File out;
        File in;
        int argIdx = 0;
        int speedTest = -1;
        boolean overWrite = false;
        boolean monochrome = false;
        boolean gray = false;
        int numColors = 256;
        String dither = null;
        String quality = null;
        String format = null;
        Color background = null;
        boolean transparency = false;
        String paletteFileName = null;
        boolean errArgs = false;
        while (argIdx < pArgs.length && pArgs[argIdx].charAt(0) == '-' && pArgs[argIdx].length() >= 2) {
            if (pArgs[argIdx].charAt(1) == 's' || pArgs[argIdx].equals("--speedtest")) {
                if (pArgs.length > ++argIdx && pArgs[argIdx].charAt(0) != '-') {
                    try {
                        speedTest = Integer.parseInt(pArgs[argIdx++]);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        errArgs = true;
                        break;
                    }
                }
                speedTest = 10;
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'w' || pArgs[argIdx].equals("--overwrite")) {
                overWrite = true;
                ++argIdx;
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'c' || pArgs[argIdx].equals("--colors")) {
                ++argIdx;
                try {
                    numColors = Integer.parseInt(pArgs[argIdx++]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    errArgs = true;
                    break;
                }
            }
            if (pArgs[argIdx].charAt(1) == 'g' || pArgs[argIdx].equals("--grayscale")) {
                ++argIdx;
                gray = true;
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'm' || pArgs[argIdx].equals("--monochrome")) {
                ++argIdx;
                numColors = 2;
                monochrome = true;
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'd' || pArgs[argIdx].equals("--dither")) {
                int n = ++argIdx;
                ++argIdx;
                dither = pArgs[n];
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'p' || pArgs[argIdx].equals("--palette")) {
                int n = ++argIdx;
                ++argIdx;
                paletteFileName = pArgs[n];
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'q' || pArgs[argIdx].equals("--quality")) {
                int n = ++argIdx;
                ++argIdx;
                quality = pArgs[n];
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'b' || pArgs[argIdx].equals("--bgcolor")) {
                ++argIdx;
                try {
                    background = StringUtil.toColor(pArgs[argIdx++]);
                    continue;
                }
                catch (Exception e) {
                    errArgs = true;
                    break;
                }
            }
            if (pArgs[argIdx].charAt(1) == 't' || pArgs[argIdx].equals("--transparency")) {
                ++argIdx;
                transparency = true;
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'f' || pArgs[argIdx].equals("--outputformat")) {
                int n = ++argIdx;
                ++argIdx;
                format = StringUtil.toLowerCase(pArgs[n]);
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'h' || pArgs[argIdx].equals("--help")) {
                ++argIdx;
                errArgs = true;
                continue;
            }
            System.err.println("Unknown option \"" + pArgs[argIdx++] + "\"");
        }
        if (errArgs || pArgs.length < argIdx + 1) {
            System.err.println("Usage: IndexImage [--help|-h] [--speedtest|-s <integer>] [--bgcolor|-b <color>] [--colors|-c <integer> | --grayscale|g | --monochrome|-m | --palette|-p <file>] [--dither|-d (default|diffusion|none)] [--quality|-q (default|high|low)] [--transparency|-t] [--outputformat|-f (gif|jpeg|png|wbmp|...)] [--overwrite|-w] <input> [<output>]");
            System.err.print("Input format names: ");
            String[] readers = ImageIO.getReaderFormatNames();
            for (int i = 0; i < readers.length; ++i) {
                System.err.print(readers[i] + (i + 1 < readers.length ? ", " : "\n"));
            }
            System.err.print("Output format names: ");
            String[] writers = ImageIO.getWriterFormatNames();
            for (int i = 0; i < writers.length; ++i) {
                System.err.print(writers[i] + (i + 1 < writers.length ? ", " : "\n"));
            }
            System.exit(5);
        }
        if (!(in = new File(pArgs[argIdx++])).exists()) {
            System.err.println("File \"" + in.getAbsolutePath() + "\" does not exist!");
            System.exit(5);
        }
        File paletteFile = null;
        if (paletteFileName != null && !(paletteFile = new File(paletteFileName)).exists()) {
            System.err.println("File \"" + in.getAbsolutePath() + "\" does not exist!");
            System.exit(5);
        }
        if (argIdx < pArgs.length) {
            out = new File(pArgs[argIdx]);
            if (format == null) {
                format = FileUtil.getExtension(out);
            }
        } else {
            String baseName = FileUtil.getBasename(in);
            if (format == null) {
                format = "png";
            }
            out = new File(baseName + '.' + format);
        }
        if (!overWrite && out.exists()) {
            System.err.println("The file \"" + out.getAbsolutePath() + "\" allready exists!");
            System.exit(5);
        }
        BufferedImage image = null;
        BufferedImage paletteImg = null;
        try {
            image = ImageIO.read(in);
            if (image == null) {
                System.err.println("No reader for image: \"" + in.getAbsolutePath() + "\"!");
                System.exit(5);
            }
            if (paletteFile != null && (paletteImg = ImageIO.read(paletteFile)) == null) {
                System.err.println("No reader for image: \"" + paletteFile.getAbsolutePath() + "\"!");
                System.exit(5);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
            System.exit(5);
        }
        int hints = 0;
        if ("DIFFUSION".equalsIgnoreCase(dither)) {
            hints |= 2;
        } else if ("DIFFUSION_ALTSCANS".equalsIgnoreCase(dither)) {
            hints |= 3;
        } else if ("NONE".equalsIgnoreCase(dither)) {
            hints |= 1;
        }
        if ("HIGH".equalsIgnoreCase(quality)) {
            hints |= 0x200;
        } else if ("LOW".equalsIgnoreCase(quality)) {
            hints |= 0x100;
        }
        if (transparency) {
            hints |= 0x20000;
        }
        if (background != null && paletteImg == null) {
            paletteImg = IndexImage.createSolid(image, background);
        }
        long start = 0L;
        if (speedTest > 0) {
            System.out.println("Measuring speed!");
            start = System.currentTimeMillis();
        }
        if (monochrome) {
            indexed = IndexImage.getIndexedImage(image, MonochromeColorModel.getInstance(), background, hints);
            colors = MonochromeColorModel.getInstance();
        } else if (gray) {
            image = ImageUtil.toBuffered(ImageUtil.grayscale(image));
            colors = IndexImage.getIndexColorModel((Image)image, numColors, hints);
            indexed = IndexImage.getIndexedImage(image, colors, background, hints);
            if (speedTest > 0) {
                colors = IndexImage.getIndexColorModel((Image)indexed, numColors, hints);
            }
        } else if (paletteImg != null) {
            colors = IndexImage.getIndexColorModel((Image)paletteImg, numColors, hints);
            indexed = IndexImage.getIndexedImage(ImageUtil.toBuffered(image, 2), colors, background, hints);
        } else {
            image = ImageUtil.toBuffered(image, 2);
            colors = IndexImage.getIndexColorModel((Image)image, numColors, hints);
            indexed = IndexImage.getIndexedImage(image, colors, background, hints);
        }
        if (speedTest > 0) {
            end = System.currentTimeMillis();
            System.out.println("Color selection + dither: " + (end - start) + " ms");
        }
        try {
            if (!ImageIO.write((RenderedImage)indexed, format, out)) {
                System.err.println("No writer for format: \"" + format + "\"!");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        if (speedTest > 0) {
            System.out.println("Measuring speed!");
            for (int i = 0; i < 10; ++i) {
                IndexImage.getIndexedImage(image, colors, background, hints);
            }
            long time = 0L;
            for (int i = 0; i < speedTest; ++i) {
                start = System.currentTimeMillis();
                IndexImage.getIndexedImage(image, colors, background, hints);
                end = System.currentTimeMillis();
                time += end - start;
                System.out.print('.');
                if ((i + 1) % 10 != 0) continue;
                System.out.println("\nAverage (after " + (i + 1) + " iterations): " + time / (long)(i + 1) + "ms");
            }
            System.out.println("\nDither only:");
            System.out.println("Total time (" + speedTest + " invocations): " + time + "ms");
            System.out.println("Average: " + time / (long)speedTest + "ms");
        }
    }

    private static class Cube {
        int[] min = new int[]{0, 0, 0};
        int[] max = new int[]{255, 255, 255};
        boolean done = false;
        List[] colors = null;
        int count = 0;
        static final int RED = 0;
        static final int GRN = 1;
        static final int BLU = 2;

        public Cube(List[] colors, int count) {
            this.colors = colors;
            this.count = count;
        }

        public boolean isDone() {
            return this.done;
        }

        public Cube split() {
            int c1;
            int splitChannel;
            int c0;
            int dr = this.max[0] - this.min[0] + 1;
            int dg = this.max[1] - this.min[1] + 1;
            int db = this.max[2] - this.min[2] + 1;
            if (dr >= dg) {
                c0 = 1;
                if (dr >= db) {
                    splitChannel = 0;
                    c1 = 2;
                } else {
                    splitChannel = 2;
                    c1 = 0;
                }
            } else if (dg >= db) {
                splitChannel = 1;
                c0 = 0;
                c1 = 2;
            } else {
                splitChannel = 2;
                c0 = 0;
                c1 = 1;
            }
            Cube ret = this.splitChannel(splitChannel, c0, c1);
            if (ret != null) {
                return ret;
            }
            ret = this.splitChannel(c0, splitChannel, c1);
            if (ret != null) {
                return ret;
            }
            ret = this.splitChannel(c1, splitChannel, c0);
            if (ret != null) {
                return ret;
            }
            this.done = true;
            return null;
        }

        public Cube splitChannel(int splitChannel, int c0, int c1) {
            if (this.min[splitChannel] == this.max[splitChannel]) {
                return null;
            }
            int splitSh4 = (2 - splitChannel) * 4;
            int c0Sh4 = (2 - c0) * 4;
            int c1Sh4 = (2 - c1) * 4;
            int half = this.count / 2;
            int[] counts = new int[256];
            int tcount = 0;
            int[] minIdx = new int[]{this.min[0] >> 4, this.min[1] >> 4, this.min[2] >> 4};
            int[] maxIdx = new int[]{this.max[0] >> 4, this.max[1] >> 4, this.max[2] >> 4};
            int minR = this.min[0];
            int minG = this.min[1];
            int minB = this.min[2];
            int maxR = this.max[0];
            int maxG = this.max[1];
            int maxB = this.max[2];
            int[] vals = new int[]{0, 0, 0};
            for (int i = minIdx[splitChannel]; i <= maxIdx[splitChannel]; ++i) {
                int idx1 = i << splitSh4;
                for (int j = minIdx[c0]; j <= maxIdx[c0]; ++j) {
                    int idx2 = idx1 | j << c0Sh4;
                    for (int k = minIdx[c1]; k <= maxIdx[c1]; ++k) {
                        int idx = idx2 | k << c1Sh4;
                        List v = this.colors[idx];
                        if (v == null) continue;
                        for (Counter c : v) {
                            int val = c.val;
                            vals[0] = (val & 0xFF0000) >> 16;
                            vals[1] = (val & 0xFF00) >> 8;
                            vals[2] = val & 0xFF;
                            if (vals[0] < minR || vals[0] > maxR || vals[1] < minG || vals[1] > maxG || vals[2] < minB || vals[2] > maxB) continue;
                            int n = vals[splitChannel];
                            counts[n] = counts[n] + c.count;
                            tcount += c.count;
                        }
                    }
                }
                if (tcount >= half) break;
            }
            tcount = 0;
            int lastAdd = -1;
            int splitLo = this.min[splitChannel];
            int splitHi = this.max[splitChannel];
            for (int i = this.min[splitChannel]; i <= this.max[splitChannel]; ++i) {
                int c = counts[i];
                if (c == 0) {
                    if (tcount != 0 || i >= this.max[splitChannel]) continue;
                    this.min[splitChannel] = i + 1;
                    continue;
                }
                if (tcount + c < half) {
                    lastAdd = i;
                    tcount += c;
                    continue;
                }
                if (half - tcount <= tcount + c - half) {
                    if (lastAdd == -1) {
                        if (c == this.count) {
                            this.max[splitChannel] = i;
                            return null;
                        }
                        splitLo = i;
                        splitHi = i + 1;
                        break;
                    }
                    splitLo = lastAdd;
                    splitHi = i;
                    break;
                }
                if (i == this.max[splitChannel]) {
                    if (c == this.count) {
                        return null;
                    }
                    splitLo = lastAdd;
                    splitHi = i;
                    break;
                }
                tcount += c;
                splitLo = i;
                splitHi = i + 1;
                break;
            }
            Cube ret = new Cube(this.colors, tcount);
            this.count -= tcount;
            ret.min[splitChannel] = this.min[splitChannel];
            ret.max[splitChannel] = splitLo;
            this.min[splitChannel] = splitHi;
            ret.min[c0] = this.min[c0];
            ret.max[c0] = this.max[c0];
            ret.min[c1] = this.min[c1];
            ret.max[c1] = this.max[c1];
            return ret;
        }

        public int averageColor() {
            if (this.count == 0) {
                return 0;
            }
            float red = 0.0f;
            float grn = 0.0f;
            float blu = 0.0f;
            int minR = this.min[0];
            int minG = this.min[1];
            int minB = this.min[2];
            int maxR = this.max[0];
            int maxG = this.max[1];
            int maxB = this.max[2];
            int[] minIdx = new int[]{minR >> 4, minG >> 4, minB >> 4};
            int[] maxIdx = new int[]{maxR >> 4, maxG >> 4, maxB >> 4};
            for (int i = minIdx[0]; i <= maxIdx[0]; ++i) {
                int idx1 = i << 8;
                for (int j = minIdx[1]; j <= maxIdx[1]; ++j) {
                    int idx2 = idx1 | j << 4;
                    for (int k = minIdx[2]; k <= maxIdx[2]; ++k) {
                        int idx = idx2 | k;
                        List v = this.colors[idx];
                        if (v == null) continue;
                        for (Counter c : v) {
                            int val = c.val;
                            int ired = (val & 0xFF0000) >> 16;
                            int igrn = (val & 0xFF00) >> 8;
                            int iblu = val & 0xFF;
                            if (ired < minR || ired > maxR || igrn < minG || igrn > maxG || iblu < minB || iblu > maxB) continue;
                            float weight = (float)c.count / (float)this.count;
                            red += (float)ired * weight;
                            grn += (float)igrn * weight;
                            blu += (float)iblu * weight;
                        }
                    }
                }
            }
            return (int)(red + 0.5f) << 16 | (int)(grn + 0.5f) << 8 | (int)(blu + 0.5f);
        }
    }

    private static class Counter {
        public int val;
        public int count = 1;

        public Counter(int val) {
            this.val = val;
        }

        public boolean add(int val) {
            if (this.val != val) {
                return false;
            }
            ++this.count;
            return true;
        }
    }
}

