/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

class InverseColorMap {
    static final int QUANTBITS = 5;
    static final int TRUNCBITS = 3;
    static final int QUANTMASK_BLUE = 31;
    static final int QUANTMASK_GREEN = 992;
    static final int QUANTMASK_RED = 31744;
    static final int MAXQUANTVAL = 32;
    byte[] mRGBMapByte;
    int[] mRGBMapInt;
    int mNumColors;
    int mMaxColor;
    byte[] mInverseRGB;
    int mTransparentIndex = -1;

    InverseColorMap(byte[] pRGBColorMap) {
        this(pRGBColorMap, -1);
    }

    InverseColorMap(int[] pRGBColorMap) {
        this(pRGBColorMap, -1);
    }

    InverseColorMap(byte[] pRGBColorMap, int pTransparent) {
        this.mRGBMapByte = pRGBColorMap;
        this.mNumColors = this.mRGBMapByte.length / 4;
        this.mTransparentIndex = pTransparent;
        this.mInverseRGB = new byte[32768];
        this.initIRGB(new int[32768]);
    }

    InverseColorMap(int[] pRGBColorMap, int pTransparent) {
        this.mRGBMapInt = pRGBColorMap;
        this.mNumColors = this.mRGBMapInt.length;
        this.mTransparentIndex = pTransparent;
        this.mInverseRGB = new byte[32768];
        this.initIRGB(new int[32768]);
    }

    void initIRGB(int[] pTemp) {
        int x = 8;
        int xsqr = 64;
        int xsqr2 = 128;
        for (int i = 0; i < this.mNumColors; ++i) {
            int blue;
            int green;
            int red;
            if (i == this.mTransparentIndex) continue;
            if (this.mRGBMapByte != null) {
                red = this.mRGBMapByte[i * 4] & 0xFF;
                green = this.mRGBMapByte[i * 4 + 1] & 0xFF;
                blue = this.mRGBMapByte[i * 4 + 2] & 0xFF;
            } else if (this.mRGBMapInt != null) {
                red = this.mRGBMapInt[i] >> 16 & 0xFF;
                green = this.mRGBMapInt[i] >> 8 & 0xFF;
                blue = this.mRGBMapInt[i] & 0xFF;
            } else {
                throw new IllegalStateException("colormap == null");
            }
            int rdist = red - 4;
            int gdist = green - 4;
            int bdist = blue - 4;
            rdist = rdist * rdist + gdist * gdist + bdist * bdist;
            int rinc = 2 * (64 - (red << 3));
            int ginc = 2 * (64 - (green << 3));
            int binc = 2 * (64 - (blue << 3));
            int rgbI = 0;
            int r = 0;
            int rxx = rinc;
            while (r < 32) {
                int g = 0;
                gdist = rdist;
                int gxx = ginc;
                while (g < 32) {
                    int b = 0;
                    bdist = gdist;
                    int bxx = binc;
                    while (b < 32) {
                        if (i == 0 || pTemp[rgbI] > bdist) {
                            pTemp[rgbI] = bdist;
                            this.mInverseRGB[rgbI] = (byte)i;
                        }
                        bdist += bxx;
                        ++b;
                        ++rgbI;
                        bxx += 128;
                    }
                    gdist += gxx;
                    ++g;
                    gxx += 128;
                }
                rdist += rxx;
                ++r;
                rxx += 128;
            }
        }
    }

    public final int getIndexNearest(int pColor) {
        return this.mInverseRGB[(pColor >> 9 & 0x7C00) + (pColor >> 6 & 0x3E0) + (pColor >> 3 & 0x1F)] & 0xFF;
    }

    public final int getIndexNearest(int pRed, int pGreen, int pBlue) {
        return this.mInverseRGB[(pRed << 7 & 0x7C00) + (pGreen << 2 & 0x3E0) + (pBlue >> 3 & 0x1F)] & 0xFF;
    }
}

