/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.EmptyReader;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundReader
extends Reader {
    private Reader mCurrent;
    private List<Reader> mReaders;
    protected final Object mLock;
    protected final boolean mMarkSupported;
    private int mCurrentReader;
    private int mMarkedReader;
    private int mMark;
    private int mNext;

    public CompoundReader(Iterator<Reader> pReaders) {
        super(Validate.notNull(pReaders, "readers"));
        this.mLock = pReaders;
        this.mReaders = new ArrayList<Reader>();
        boolean markSupported = true;
        while (pReaders.hasNext()) {
            Reader reader = pReaders.next();
            if (reader == null) {
                throw new NullPointerException("readers cannot contain null-elements");
            }
            this.mReaders.add(reader);
            markSupported = markSupported && reader.markSupported();
        }
        this.mMarkSupported = markSupported;
        this.mCurrent = this.nextReader();
    }

    protected final Reader nextReader() {
        this.mCurrent = this.mCurrentReader >= this.mReaders.size() ? new EmptyReader() : this.mReaders.get(this.mCurrentReader++);
        this.mNext = 0;
        return this.mCurrent;
    }

    protected final void ensureOpen() throws IOException {
        if (this.mReaders == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void close() throws IOException {
        for (Reader reader : this.mReaders) {
            reader.close();
        }
        this.mReaders = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int pReadLimit) throws IOException {
        if (pReadLimit < 0) {
            throw new IllegalArgumentException("Read limit < 0");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureOpen();
            this.mMark = this.mNext;
            this.mMarkedReader = this.mCurrentReader;
            this.mCurrent.mark(pReadLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.mCurrentReader != this.mMarkedReader) {
                for (int i = this.mCurrentReader; i >= this.mMarkedReader; --i) {
                    this.mReaders.get(i).reset();
                }
                this.mCurrentReader = this.mMarkedReader - 1;
                this.nextReader();
            }
            this.mCurrent.reset();
            this.mNext = this.mMark;
        }
    }

    @Override
    public boolean markSupported() {
        return this.mMarkSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            int read = this.mCurrent.read();
            if (read < 0 && this.mCurrentReader < this.mReaders.size()) {
                this.nextReader();
                return this.read();
            }
            ++this.mNext;
            return read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] pBuffer, int pOffset, int pLength) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            int read = this.mCurrent.read(pBuffer, pOffset, pLength);
            if (read < 0 && this.mCurrentReader < this.mReaders.size()) {
                this.nextReader();
                return this.read(pBuffer, pOffset, pLength);
            }
            this.mNext += read;
            return read;
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.mCurrent.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long pChars) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            long skipped = this.mCurrent.skip(pChars);
            if (skipped == 0L && this.mCurrentReader < this.mReaders.size()) {
                this.nextReader();
                return this.skip(pChars);
            }
            this.mNext = (int)((long)this.mNext + skipped);
            return skipped;
        }
    }
}

