/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.AbstractCachedSeekableStream;
import com.twelvemonkeys.lang.Validate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class FileCacheSeekableStream
extends AbstractCachedSeekableStream {
    private byte[] mBuffer = new byte[1024];

    public FileCacheSeekableStream(InputStream pStream) throws IOException {
        this(pStream, "iocache", null);
    }

    public FileCacheSeekableStream(InputStream pStream, String pTempBaseName) throws IOException {
        this(pStream, pTempBaseName, null);
    }

    public FileCacheSeekableStream(InputStream pStream, String pTempBaseName, File pTempDir) throws IOException {
        this(Validate.notNull(pStream, "stream"), FileCacheSeekableStream.createTempFile(pTempBaseName, pTempDir));
    }

    static File createTempFile(String pTempBaseName, File pTempDir) throws IOException {
        Validate.notNull(pTempBaseName, "tempBaseName");
        File file = File.createTempFile(pTempBaseName, null, pTempDir);
        file.deleteOnExit();
        return file;
    }

    FileCacheSeekableStream(InputStream pStream, File pFile) throws FileNotFoundException {
        super(pStream, new FileCache(pFile));
    }

    public final boolean isCachedMemory() {
        return false;
    }

    public final boolean isCachedFile() {
        return true;
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this.mBuffer = null;
    }

    public int read() throws IOException {
        int read;
        this.checkOpen();
        if (this.mPosition == this.mStreamPosition) {
            read = this.readAhead(this.mBuffer, 0, this.mBuffer.length);
            if (read >= 0) {
                read = this.mBuffer[0] & 0xFF;
            }
        } else {
            this.syncPosition();
            read = this.getCache().read();
        }
        if (read != -1) {
            ++this.mPosition;
        }
        return read;
    }

    public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
        int length;
        this.checkOpen();
        if (this.mPosition == this.mStreamPosition) {
            length = this.readAhead(pBytes, pOffset, pLength);
        } else {
            this.syncPosition();
            length = this.getCache().read(pBytes, pOffset, (int)Math.min((long)pLength, this.mStreamPosition - this.mPosition));
        }
        if (length > 0) {
            this.mPosition += (long)length;
        }
        return length;
    }

    private int readAhead(byte[] pBytes, int pOffset, int pLength) throws IOException {
        int length = this.mStream.read(pBytes, pOffset, pLength);
        if (length > 0) {
            this.mStreamPosition += (long)length;
            this.getCache().write(pBytes, pOffset, length);
        }
        return length;
    }

    static final class FileCache
    extends AbstractCachedSeekableStream.StreamCache {
        private RandomAccessFile mCacheFile;

        public FileCache(File pFile) throws FileNotFoundException {
            Validate.notNull(pFile, "file");
            this.mCacheFile = new RandomAccessFile(pFile, "rw");
        }

        public void write(int pByte) throws IOException {
            this.mCacheFile.write(pByte);
        }

        public void write(byte[] pBuffer, int pOffset, int pLength) throws IOException {
            this.mCacheFile.write(pBuffer, pOffset, pLength);
        }

        public int read() throws IOException {
            return this.mCacheFile.read();
        }

        public int read(byte[] pBuffer, int pOffset, int pLength) throws IOException {
            return this.mCacheFile.read(pBuffer, pOffset, pLength);
        }

        public void seek(long pPosition) throws IOException {
            this.mCacheFile.seek(pPosition);
        }

        public long getPosition() throws IOException {
            return this.mCacheFile.getFilePointer();
        }
    }
}

