/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int mWritten;

    public LittleEndianDataOutputStream(OutputStream pStream) {
        super(pStream);
        if (pStream == null) {
            throw new IllegalArgumentException("stream == null");
        }
    }

    public synchronized void write(int pByte) throws IOException {
        this.out.write(pByte);
        ++this.mWritten;
    }

    public synchronized void write(byte[] pBytes, int pOffset, int pLength) throws IOException {
        this.out.write(pBytes, pOffset, pLength);
        this.mWritten += pLength;
    }

    public void writeBoolean(boolean pBoolean) throws IOException {
        if (pBoolean) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeByte(int pByte) throws IOException {
        this.out.write(pByte);
        ++this.mWritten;
    }

    public void writeShort(int pShort) throws IOException {
        this.out.write(pShort & 0xFF);
        this.out.write(pShort >>> 8 & 0xFF);
        this.mWritten += 2;
    }

    public void writeChar(int pChar) throws IOException {
        this.out.write(pChar & 0xFF);
        this.out.write(pChar >>> 8 & 0xFF);
        this.mWritten += 2;
    }

    public void writeInt(int pInt) throws IOException {
        this.out.write(pInt & 0xFF);
        this.out.write(pInt >>> 8 & 0xFF);
        this.out.write(pInt >>> 16 & 0xFF);
        this.out.write(pInt >>> 24 & 0xFF);
        this.mWritten += 4;
    }

    public void writeLong(long pLong) throws IOException {
        this.out.write((int)pLong & 0xFF);
        this.out.write((int)(pLong >>> 8) & 0xFF);
        this.out.write((int)(pLong >>> 16) & 0xFF);
        this.out.write((int)(pLong >>> 24) & 0xFF);
        this.out.write((int)(pLong >>> 32) & 0xFF);
        this.out.write((int)(pLong >>> 40) & 0xFF);
        this.out.write((int)(pLong >>> 48) & 0xFF);
        this.out.write((int)(pLong >>> 56) & 0xFF);
        this.mWritten += 8;
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeBytes(String pString) throws IOException {
        int length = pString.length();
        for (int i = 0; i < length; ++i) {
            this.out.write((byte)pString.charAt(i));
        }
        this.mWritten += length;
    }

    public void writeChars(String pString) throws IOException {
        int length = pString.length();
        for (int i = 0; i < length; ++i) {
            char c = pString.charAt(i);
            this.out.write(c & 0xFF);
            this.out.write(c >>> 8 & 0xFF);
        }
        this.mWritten += length * 2;
    }

    public void writeUTF(String pString) throws IOException {
        char c;
        int i;
        int numchars = pString.length();
        int numbytes = 0;
        for (i = 0; i < numchars; ++i) {
            c = pString.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++numbytes;
                continue;
            }
            if (c > '\u07ff') {
                numbytes += 3;
                continue;
            }
            numbytes += 2;
        }
        if (numbytes > 65535) {
            throw new UTFDataFormatException();
        }
        this.out.write(numbytes >>> 8 & 0xFF);
        this.out.write(numbytes & 0xFF);
        for (i = 0; i < numchars; ++i) {
            c = pString.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.out.write(0xE0 | c >> 12 & 0xF);
                this.out.write(0x80 | c >> 6 & 0x3F);
                this.out.write(0x80 | c & 0x3F);
                this.mWritten += 2;
                continue;
            }
            this.out.write(0xC0 | c >> 6 & 0x1F);
            this.out.write(0x80 | c & 0x3F);
            ++this.mWritten;
        }
        this.mWritten += numchars + 2;
    }

    public int size() {
        return this.mWritten;
    }
}

