/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.Seekable;
import com.twelvemonkeys.io.SeekableInputStream;
import com.twelvemonkeys.io.SeekableOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;

public abstract class RandomAccessStream
implements Seekable,
DataInput,
DataOutput {
    SeekableInputStream mInputView = null;
    SeekableOutputStream mOutputView = null;

    public int read() throws IOException {
        try {
            return this.readByte() & 0xFF;
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
        int i;
        if (pBytes == null) {
            throw new NullPointerException("bytes == null");
        }
        if (pOffset < 0 || pOffset > pBytes.length || pLength < 0 || pOffset + pLength > pBytes.length || pOffset + pLength < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (pLength == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        pBytes[pOffset] = (byte)c;
        try {
            for (i = 1; i < pLength && (c = this.read()) != -1; ++i) {
                pBytes[pOffset + i] = (byte)c;
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return i;
    }

    public final int read(byte[] pBytes) throws IOException {
        return this.read(pBytes, 0, pBytes != null ? pBytes.length : 1);
    }

    public final SeekableInputStream asInputStream() {
        if (this.mInputView == null) {
            this.mInputView = new InputStreamView(this);
        }
        return this.mInputView;
    }

    public final SeekableOutputStream asOutputStream() {
        if (this.mOutputView == null) {
            this.mOutputView = new OutputStreamView(this);
        }
        return this.mOutputView;
    }

    static final class OutputStreamView
    extends SeekableOutputStream {
        private final RandomAccessStream mStream;

        public OutputStreamView(RandomAccessStream pStream) {
            if (pStream == null) {
                throw new IllegalArgumentException("stream == null");
            }
            this.mStream = pStream;
        }

        public boolean isCached() {
            return this.mStream.isCached();
        }

        public boolean isCachedFile() {
            return this.mStream.isCachedFile();
        }

        public boolean isCachedMemory() {
            return this.mStream.isCachedMemory();
        }

        protected void closeImpl() throws IOException {
            this.mStream.close();
        }

        protected void flushBeforeImpl(long pPosition) throws IOException {
            this.mStream.flushBefore(pPosition);
        }

        protected void seekImpl(long pPosition) throws IOException {
            this.mStream.seek(pPosition);
        }

        public void write(int pByte) throws IOException {
            this.mStream.write(pByte);
        }

        public void write(byte[] pBytes, int pOffset, int pLength) throws IOException {
            this.mStream.write(pBytes, pOffset, pLength);
        }
    }

    static final class InputStreamView
    extends SeekableInputStream {
        private final RandomAccessStream mStream;

        public InputStreamView(RandomAccessStream pStream) {
            if (pStream == null) {
                throw new IllegalArgumentException("stream == null");
            }
            this.mStream = pStream;
        }

        public boolean isCached() {
            return this.mStream.isCached();
        }

        public boolean isCachedFile() {
            return this.mStream.isCachedFile();
        }

        public boolean isCachedMemory() {
            return this.mStream.isCachedMemory();
        }

        protected void closeImpl() throws IOException {
            this.mStream.close();
        }

        protected void flushBeforeImpl(long pPosition) throws IOException {
            this.mStream.flushBefore(pPosition);
        }

        protected void seekImpl(long pPosition) throws IOException {
            this.mStream.seek(pPosition);
        }

        public int read() throws IOException {
            return this.mStream.read();
        }

        public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
            return this.mStream.read(pBytes, pOffset, pLength);
        }
    }
}

