/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.Seekable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;

public abstract class SeekableOutputStream
extends OutputStream
implements Seekable {
    long mPosition;
    long mFlushedPosition;
    boolean mClosed;
    protected Stack<Long> mMarkedPositions = new Stack();

    public final void write(byte[] pBytes) throws IOException {
        this.write(pBytes, 0, pBytes != null ? pBytes.length : 1);
    }

    public final void seek(long pPosition) throws IOException {
        this.checkOpen();
        if (pPosition < this.mFlushedPosition) {
            throw new IndexOutOfBoundsException("position < flushedPosition!");
        }
        this.seekImpl(pPosition);
        this.mPosition = pPosition;
    }

    protected abstract void seekImpl(long var1) throws IOException;

    public final void mark() {
        this.mMarkedPositions.push(this.mPosition);
    }

    public final void reset() throws IOException {
        this.checkOpen();
        if (!this.mMarkedPositions.isEmpty()) {
            long newPos = this.mMarkedPositions.pop();
            if (newPos < this.mFlushedPosition) {
                throw new IOException("Previous marked position has been discarded!");
            }
            this.seek(newPos);
        }
    }

    public final void flushBefore(long pPosition) throws IOException {
        if (pPosition < this.mFlushedPosition) {
            throw new IndexOutOfBoundsException("position < flushedPosition!");
        }
        if (pPosition > this.getStreamPosition()) {
            throw new IndexOutOfBoundsException("position > getStreamPosition()!");
        }
        this.checkOpen();
        this.flushBeforeImpl(pPosition);
        this.mFlushedPosition = pPosition;
    }

    protected abstract void flushBeforeImpl(long var1) throws IOException;

    public final void flush() throws IOException {
        this.flushBefore(this.mFlushedPosition);
    }

    public final long getFlushedPosition() throws IOException {
        this.checkOpen();
        return this.mFlushedPosition;
    }

    public final long getStreamPosition() throws IOException {
        this.checkOpen();
        return this.mPosition;
    }

    protected final void checkOpen() throws IOException {
        if (this.mClosed) {
            throw new IOException("closed");
        }
    }

    public final void close() throws IOException {
        this.checkOpen();
        this.mClosed = true;
        this.closeImpl();
    }

    protected abstract void closeImpl() throws IOException;
}

