/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.FastByteArrayOutputStream;
import com.twelvemonkeys.io.enc.Decoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Base64Decoder
implements Decoder {
    static final char[] PEM_ARRAY;
    static final byte[] PEM_CONVERT_ARRAY;
    private byte[] mDecodeBuffer = new byte[4];
    private ByteArrayOutputStream mWrapped;
    private Object mWrappedObject;

    protected static int readFully(InputStream pStream, byte[] pBytes, int pOffset, int pLength) throws IOException {
        for (int i = 0; i < pLength; ++i) {
            int read = pStream.read();
            if (read == -1) {
                return i != 0 ? i : -1;
            }
            pBytes[i + pOffset] = (byte)read;
        }
        return pLength;
    }

    protected boolean decodeAtom(InputStream pInput, OutputStream pOutput, int pLength) throws IOException {
        int read;
        int byte0 = -1;
        int byte1 = -1;
        int byte2 = -1;
        int byte3 = -1;
        if (pLength < 2) {
            throw new IOException("BASE64Decoder: Not enough bytes for an atom.");
        }
        do {
            if ((read = pInput.read()) != -1) continue;
            return false;
        } while (read == 10 || read == 13);
        this.mDecodeBuffer[0] = (byte)read;
        read = Base64Decoder.readFully(pInput, this.mDecodeBuffer, 1, pLength - 1);
        if (read == -1) {
            return false;
        }
        int length = pLength;
        if (length > 3 && this.mDecodeBuffer[3] == 61) {
            length = 3;
        }
        if (length > 2 && this.mDecodeBuffer[2] == 61) {
            length = 2;
        }
        switch (length) {
            case 4: {
                byte3 = PEM_CONVERT_ARRAY[this.mDecodeBuffer[3] & 0xFF];
            }
            case 3: {
                byte2 = PEM_CONVERT_ARRAY[this.mDecodeBuffer[2] & 0xFF];
            }
            case 2: {
                byte1 = PEM_CONVERT_ARRAY[this.mDecodeBuffer[1] & 0xFF];
                byte0 = PEM_CONVERT_ARRAY[this.mDecodeBuffer[0] & 0xFF];
            }
        }
        switch (length) {
            case 2: {
                pOutput.write((byte)(byte0 << 2 & 0xFC | byte1 >>> 4 & 3));
                break;
            }
            case 3: {
                pOutput.write((byte)(byte0 << 2 & 0xFC | byte1 >>> 4 & 3));
                pOutput.write((byte)(byte1 << 4 & 0xF0 | byte2 >>> 2 & 0xF));
                break;
            }
            case 4: {
                pOutput.write((byte)(byte0 << 2 & 0xFC | byte1 >>> 4 & 3));
                pOutput.write((byte)(byte1 << 4 & 0xF0 | byte2 >>> 2 & 0xF));
                pOutput.write((byte)(byte2 << 6 & 0xC0 | byte3 & 0x3F));
            }
        }
        return true;
    }

    void decodeBuffer(InputStream pInput, ByteArrayOutputStream pOutput, int pLength) throws IOException {
        int i;
        int k;
        do {
            k = 72;
            i = 0;
            while (i + 4 < k && this.decodeAtom(pInput, pOutput, 4)) {
                i += 4;
            }
        } while (this.decodeAtom(pInput, pOutput, k - i) && pOutput.size() + 54 < pLength);
    }

    public int decode(InputStream pStream, byte[] pBuffer) throws IOException {
        if (this.mWrappedObject != pBuffer) {
            this.mWrapped = new FastByteArrayOutputStream(pBuffer);
            this.mWrappedObject = pBuffer;
        }
        this.mWrapped.reset();
        this.decodeBuffer(pStream, this.mWrapped, pBuffer.length);
        return this.mWrapped.size();
    }

    static {
        int i;
        PEM_ARRAY = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        PEM_CONVERT_ARRAY = new byte[256];
        for (i = 0; i < 255; ++i) {
            Base64Decoder.PEM_CONVERT_ARRAY[i] = -1;
        }
        for (i = 0; i < PEM_ARRAY.length; ++i) {
            Base64Decoder.PEM_CONVERT_ARRAY[Base64Decoder.PEM_ARRAY[i]] = (byte)i;
        }
    }
}

