/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.DecodeException;
import com.twelvemonkeys.io.enc.Decoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class PackBits16Decoder
implements Decoder {
    private final boolean mDisableNoop;
    private int mLeftOfRun;
    private boolean mSplitRun;
    private boolean mEOF;

    public PackBits16Decoder() {
        this(false);
    }

    public PackBits16Decoder(boolean pDisableNoop) {
        this.mDisableNoop = pDisableNoop;
    }

    public int decode(InputStream pStream, byte[] pBuffer) throws IOException {
        if (this.mEOF) {
            return -1;
        }
        int read = 0;
        int max = pBuffer.length;
        while (read < max) {
            int n;
            if (this.mSplitRun) {
                n = this.mLeftOfRun;
                this.mSplitRun = false;
            } else {
                int b = pStream.read();
                if (b < 0) {
                    this.mEOF = true;
                    break;
                }
                n = (byte)b;
            }
            if (n >= 0 && 2 * (n + 1) + read > max) {
                this.mLeftOfRun = n;
                this.mSplitRun = true;
                break;
            }
            if (n < 0 && 2 * (-n + 1) + read > max) {
                this.mLeftOfRun = n;
                this.mSplitRun = true;
                break;
            }
            try {
                if (n >= 0) {
                    int len = 2 * (n + 1);
                    PackBits16Decoder.readFully(pStream, pBuffer, read, len);
                    read += len;
                    continue;
                }
                if (!this.mDisableNoop && n == -128) continue;
                byte value1 = PackBits16Decoder.readByte(pStream);
                byte value2 = PackBits16Decoder.readByte(pStream);
                for (int i = -n + 1; i > 0; --i) {
                    pBuffer[read++] = value1;
                    pBuffer[read++] = value2;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new DecodeException("Error in PackBits decompression, data seems corrupt", e);
            }
        }
        return read;
    }

    private static byte readByte(InputStream pStream) throws IOException {
        int read = pStream.read();
        if (read < 0) {
            throw new EOFException("Unexpected end of PackBits stream");
        }
        return (byte)read;
    }

    private static void readFully(InputStream pStream, byte[] pBuffer, int pOffset, int pLength) throws IOException {
        int count;
        if (pLength < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int read = 0; read < pLength; read += count) {
            count = pStream.read(pBuffer, pOffset + read, pLength - read);
            if (count >= 0) continue;
            throw new EOFException("Unexpected end of PackBits stream");
        }
    }
}

