/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.AbstractRLEDecoder;
import java.io.IOException;
import java.io.InputStream;

final class RLE4Decoder
extends AbstractRLEDecoder {
    public RLE4Decoder(int pWidth, int pHeight) {
        super((pWidth + 1) / 2, pHeight);
    }

    protected void decodeRow(InputStream pInput) throws IOException {
        int deltaX = 0;
        int deltaY = 0;
        while (this.mSrcY >= 0) {
            block15: {
                int byte2;
                int byte1;
                block14: {
                    if (byte1 != 0) break block14;
                    switch (byte2) {
                        case 0: {
                            if (this.mSrcX != 0) {
                                this.mSrcX = this.mRow.length;
                                break;
                            }
                            break block15;
                        }
                        case 1: {
                            this.mSrcX = this.mRow.length;
                            this.mSrcY = 0;
                            break;
                        }
                        case 2: {
                            deltaX = this.mSrcX + pInput.read();
                            deltaY = this.mSrcY - RLE4Decoder.checkEOF(pInput.read());
                            this.mSrcX = this.mRow.length;
                            break;
                        }
                        default: {
                            int packed;
                            boolean paddingByte;
                            boolean bl = paddingByte = (byte2 + 1) / 2 % 2 != 0;
                            for (byte2 = RLE4Decoder.checkEOF(pInput.read()); byte2 > 1; byte2 -= 2) {
                                packed = RLE4Decoder.checkEOF(pInput.read());
                                this.mRow[this.mSrcX++] = (byte)packed;
                            }
                            if (byte2 == 1) {
                                packed = RLE4Decoder.checkEOF(pInput.read());
                                this.mRow[this.mSrcX++] = (byte)(packed & 0xF0);
                            }
                            if (paddingByte) {
                                RLE4Decoder.checkEOF(pInput.read());
                                break;
                            }
                            break block15;
                        }
                    }
                    break block15;
                }
                for (byte1 = pInput.read(); byte1 > 1; byte1 -= 2) {
                    this.mRow[this.mSrcX++] = (byte)byte2;
                }
                if (byte1 == 1) {
                    this.mRow[this.mSrcX++] = (byte)(byte2 & 0xF0);
                }
            }
            if (this.mSrcX != this.mRow.length) continue;
            if (deltaX != 0 || deltaY != 0) {
                this.mSrcX = (deltaX + 1) / 2;
                if (deltaY > this.mSrcY) {
                    this.mSrcY = deltaY;
                    break;
                }
                deltaX = 0;
                deltaY = 0;
                continue;
            }
            this.mSrcX = 0;
            --this.mSrcY;
            break;
        }
    }
}

