/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.ole2;

import java.util.NoSuchElementException;

class SIdChain {
    int[] chain = new int[16];
    int size = 0;
    int next = 0;

    void addSID(int pSID) {
        this.ensureCapacity();
        this.chain[this.size++] = pSID;
    }

    private void ensureCapacity() {
        if (this.chain.length == this.size) {
            int[] temp = new int[this.size << 1];
            System.arraycopy(this.chain, 0, temp, 0, this.size);
            this.chain = temp;
        }
    }

    public int[] getChain() {
        int[] result = new int[this.size];
        System.arraycopy(this.chain, 0, result, 0, this.size);
        return result;
    }

    public void reset() {
        this.next = 0;
    }

    public boolean hasNext() {
        return this.next < this.size;
    }

    public int next() {
        if (this.next >= this.size) {
            throw new NoSuchElementException("No element");
        }
        return this.chain[this.next++];
    }

    public int get(int pIndex) {
        return this.chain[pIndex];
    }

    public int length() {
        return this.size;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.size * 5);
        buf.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this.chain[i]);
        }
        buf.append(']');
        return buf.toString();
    }
}

