/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

public final class Platform {
    final OperatingSystem mOS = Platform.normalizeOperatingSystem();
    final String mVersion = System.getProperty("os.version");
    final Architecture mArchitecture = Platform.normalizeArchitecture(this.mOS);
    private static final Platform INSTANCE = new Platform();

    private Platform() {
    }

    private static OperatingSystem normalizeOperatingSystem() {
        String os = System.getProperty("os.name");
        if (os == null) {
            throw new IllegalStateException("System property \"os.name\" == null");
        }
        if ((os = os.toLowerCase()).startsWith("windows")) {
            return OperatingSystem.Windows;
        }
        if (os.startsWith("linux")) {
            return OperatingSystem.Linux;
        }
        if (os.startsWith("mac os")) {
            return OperatingSystem.MacOS;
        }
        if (os.startsWith("solaris") || os.startsWith("sunos")) {
            return OperatingSystem.Solaris;
        }
        return OperatingSystem.Unknown;
    }

    private static Architecture normalizeArchitecture(OperatingSystem pOsName) {
        String arch = System.getProperty("os.arch");
        if (arch == null) {
            throw new IllegalStateException("System property \"os.arch\" == null");
        }
        arch = arch.toLowerCase();
        if (pOsName == OperatingSystem.Windows && (arch.startsWith("x86") || arch.startsWith("i386"))) {
            return Architecture.X86;
        }
        if (pOsName == OperatingSystem.Linux) {
            if (arch.startsWith("x86") || arch.startsWith("i386")) {
                return Architecture.I386;
            }
            if (arch.startsWith("i686")) {
                return Architecture.I686;
            }
        } else if (pOsName == OperatingSystem.MacOS) {
            if (arch.startsWith("power") || arch.startsWith("ppc")) {
                return Architecture.PPC;
            }
            if (arch.startsWith("i386")) {
                return Architecture.I386;
            }
        } else if (pOsName == OperatingSystem.Solaris) {
            if (arch.startsWith("sparc")) {
                return Architecture.SPARC;
            }
            if (arch.startsWith("x86")) {
                return Architecture.X86;
            }
        }
        return Architecture.Unknown;
    }

    public static Platform get() {
        return INSTANCE;
    }

    public OperatingSystem getOS() {
        return this.mOS;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public Architecture getArchitecture() {
        return this.mArchitecture;
    }

    public static OperatingSystem os() {
        return Platform.INSTANCE.mOS;
    }

    public static String version() {
        return Platform.INSTANCE.mVersion;
    }

    public static Architecture arch() {
        return Platform.INSTANCE.mArchitecture;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperatingSystem {
        Windows("Windows", "win"),
        Linux("Linux", "lnx"),
        Solaris("Solaris", "sun"),
        MacOS("Mac OS", "osx"),
        Unknown(System.getProperty("os.name"), "");

        final String mId;
        final String mName;

        private OperatingSystem(String pName, String pId) {
            this.mName = pName;
            this.mId = pId;
        }

        public String getName() {
            return this.mName;
        }

        public String toString() {
            return this.mId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Architecture {
        X86("x86"),
        I386("i386"),
        I686("i686"),
        PPC("ppc"),
        SPARC("sparc"),
        Unknown(System.getProperty("os.arch"));

        final String mName;

        private Architecture(String pName) {
            this.mName = pName;
        }

        public String toString() {
            return this.mName;
        }
    }
}

