/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.net;

import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.net.NetUtil;
import com.twelvemonkeys.util.BASE64;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    public static final int HTTP_REDIRECT = 307;
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final String HTTP_HEADER_END = "\r\n\r\n";
    private static final String HEADER_WWW_AUTH = "WWW-Authenticate";
    private static final int BUF_SIZE = 8192;
    private int mMaxRedirects = System.getProperty("http.maxRedirects") != null ? Integer.parseInt(System.getProperty("http.maxRedirects")) : 20;
    protected int mTimeout = -1;
    protected int mConnectTimeout = -1;
    private Socket mSocket = null;
    protected InputStream mErrorStream = null;
    protected InputStream mInputStream = null;
    protected OutputStream mOutputStream = null;
    private String[] mResponseHeaders = null;
    protected Properties mResponseHeaderFields = null;
    protected Properties mRequestProperties = new Properties();

    protected HttpURLConnection(URL pURL) {
        this(pURL, 0, 0);
    }

    protected HttpURLConnection(URL pURL, int pTimeout) {
        this(pURL, pTimeout, pTimeout);
    }

    protected HttpURLConnection(URL pURL, int pTimeout, int pConnectTimeout) {
        super(pURL);
        this.setTimeout(pTimeout);
        this.mConnectTimeout = pConnectTimeout;
    }

    public void setRequestProperty(String pKey, String pValue) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        String oldValue = this.mRequestProperties.getProperty(pKey);
        if (oldValue == null) {
            this.mRequestProperties.setProperty(pKey, pValue);
        } else {
            this.mRequestProperties.setProperty(pKey, oldValue + ", " + pValue);
        }
    }

    public String getRequestProperty(String pKey) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        return this.mRequestProperties.getProperty(pKey);
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        this.getInputStream();
        String resp = this.getHeaderField(0);
        try {
            int ind = resp.indexOf(32);
            while (resp.charAt(ind) == ' ') {
                ++ind;
            }
            this.responseCode = Integer.parseInt(resp.substring(ind, ind + 3));
            this.responseMessage = resp.substring(ind + 4).trim();
            return this.responseCode;
        }
        catch (Exception e) {
            return this.responseCode;
        }
    }

    public String getHeaderField(String pName) {
        return this.mResponseHeaderFields.getProperty(StringUtil.toLowerCase(pName));
    }

    public String getHeaderField(int pIndex) {
        if (pIndex >= this.mResponseHeaders.length) {
            return null;
        }
        String field = this.mResponseHeaders[pIndex];
        if (pIndex == 0 || field == null) {
            return field;
        }
        int idx = field.indexOf(58);
        return idx > 0 ? field.substring(idx).trim() : "";
    }

    public String getHeaderFieldKey(int pIndex) {
        if (pIndex >= this.mResponseHeaders.length) {
            return null;
        }
        String field = this.mResponseHeaders[pIndex];
        if (StringUtil.isEmpty(field)) {
            return null;
        }
        int idx = field.indexOf(58);
        return StringUtil.toLowerCase(idx > 0 ? field.substring(0, idx) : field);
    }

    public void setTimeout(int pTimeout) {
        if (pTimeout < 0) {
            throw new IllegalArgumentException("Timeout must be positive.");
        }
        this.mTimeout = pTimeout;
        if (this.mSocket != null) {
            try {
                this.mSocket.setSoTimeout(pTimeout);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public int getTimeout() {
        try {
            return this.mSocket != null ? this.mSocket.getSoTimeout() : this.mTimeout;
        }
        catch (SocketException se) {
            return this.mTimeout;
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.responseCode == 404) {
            throw new FileNotFoundException(this.url.toString());
        }
        if (this.mInputStream == null) {
            return null;
        }
        if ("chunked".equalsIgnoreCase(this.getHeaderField("Transfer-Encoding"))) {
            if (!(this.mInputStream instanceof ChunkedInputStream)) {
                this.mInputStream = new ChunkedInputStream(this.mInputStream);
            }
        } else {
            int length = this.getHeaderFieldInt("Content-Length", -1);
            if (length >= 0 && !(this.mInputStream instanceof FixedLengthInputStream)) {
                this.mInputStream = new FixedLengthInputStream(this.mInputStream, length);
            }
        }
        return this.mInputStream;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.mOutputStream;
    }

    public void disconnect() {
        if (this.mSocket != null) {
            try {
                this.mSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mSocket = null;
        }
        this.connected = false;
    }

    private void connect(URL pURL, PasswordAuthentication pAuth, String pAuthType, int pRetries) throws IOException {
        int port;
        int n = port = pURL.getPort() > 0 ? pURL.getPort() : 80;
        if (this.mSocket == null) {
            this.mSocket = this.createSocket(pURL, port, this.mConnectTimeout);
            this.mSocket.setSoTimeout(this.mTimeout);
        }
        OutputStream os = this.mSocket.getOutputStream();
        HttpURLConnection.writeRequestHeaders(os, pURL, this.method, this.mRequestProperties, this.usingProxy(), pAuth, pAuthType);
        InputStream sis = this.mSocket.getInputStream();
        BufferedInputStream is = new BufferedInputStream(sis);
        InputStream header = HttpURLConnection.detatchResponseHeader(is);
        this.mResponseHeaders = HttpURLConnection.parseResponseHeader(header);
        this.mResponseHeaderFields = HttpURLConnection.parseHeaderFields(this.mResponseHeaders);
        switch (this.getResponseCode()) {
            case 200: {
                this.mInputStream = is;
                this.mErrorStream = null;
                break;
            }
            case 401: {
                String method;
                this.responseCode = -1;
                String auth = this.getHeaderField(HEADER_WWW_AUTH);
                if (StringUtil.isEmpty(auth)) {
                    throw new ProtocolException("Missing \"WWW-Authenticate\" header for response: 401 " + this.responseMessage);
                }
                int SP = auth.indexOf(" ");
                String realm = null;
                if (SP >= 0) {
                    method = auth.substring(0, SP);
                    if (auth.length() >= SP + 7) {
                        realm = auth.substring(SP + 7);
                    }
                } else {
                    method = "Basic";
                }
                PasswordAuthentication pa = Authenticator.requestPasswordAuthentication(NetUtil.createInetAddressFromURL(pURL), port, pURL.getProtocol(), realm, method);
                if (pRetries++ <= 0) {
                    throw new ProtocolException("Server redirected too many times (" + this.mMaxRedirects + ") (Authentication required: " + auth + ")");
                }
                if (pa == null) break;
                this.connect(pURL, pa, method, pRetries);
                break;
            }
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                if (this.instanceFollowRedirects) {
                    this.responseCode = -1;
                    String location = this.getHeaderField("Location");
                    URL newLoc = new URL(pURL, location);
                    if (!newLoc.getAuthority().equals(pURL.getAuthority()) || newLoc.getPort() != pURL.getPort()) {
                        this.mSocket.close();
                        this.mSocket = null;
                    }
                    if (location == null) break;
                    if (--pRetries <= 0) {
                        throw new ProtocolException("Server redirected too many times (5)");
                    }
                    this.connect(newLoc, pAuth, pAuthType, pRetries);
                    break;
                }
            }
            default: {
                this.mErrorStream = is;
                this.mInputStream = null;
            }
        }
        this.mOutputStream = os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket createSocket(final URL pURL, final int pPort, int pConnectTimeout) throws IOException {
        final HttpURLConnection current = this;
        SocketConnector connector = new SocketConnector(){
            private IOException mConnectException = null;
            private Socket mLocalSocket = null;

            public Socket getSocket() throws IOException {
                if (this.mConnectException != null) {
                    throw this.mConnectException;
                }
                return this.mLocalSocket;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    this.mLocalSocket = new Socket(pURL.getHost(), pPort);
                }
                catch (IOException ioe) {
                    this.mConnectException = ioe;
                }
                Object object = current;
                synchronized (object) {
                    current.notify();
                }
            }
        };
        Thread t = new Thread(connector);
        t.start();
        HttpURLConnection httpURLConnection = this;
        synchronized (httpURLConnection) {
            try {
                if (t.isAlive()) {
                    if (pConnectTimeout > 0) {
                        this.wait(pConnectTimeout);
                    } else {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        Socket socket = connector.getSocket();
        if (socket == null) {
            throw new ConnectException("Socket connect timed out!");
        }
        return socket;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.connected = true;
        this.connect(this.url, null, null, this.mMaxRedirects);
    }

    public boolean usingProxy() {
        return false;
    }

    private static void writeRequestHeaders(OutputStream pOut, URL pURL, String pMethod, Properties pProps, boolean pUsingProxy, PasswordAuthentication pAuth, String pAuthType) {
        PrintWriter out = new PrintWriter(pOut, true);
        if (!pUsingProxy) {
            out.println(pMethod + " " + (!StringUtil.isEmpty(pURL.getPath()) ? pURL.getPath() : "/") + (pURL.getQuery() != null ? "?" + pURL.getQuery() : "") + " HTTP/1.1");
            out.println("Host: " + pURL.getHost() + (pURL.getPort() != -1 ? ":" + pURL.getPort() : ""));
        } else {
            out.println(pMethod + " " + pURL.getProtocol() + "://" + pURL.getHost() + (pURL.getPort() != -1 ? ":" + pURL.getPort() : "") + pURL.getPath() + (pURL.getQuery() != null ? "?" + pURL.getQuery() : "") + " HTTP/1.1");
        }
        if (pAuth != null) {
            byte[] userPass = (pAuth.getUserName() + ":" + new String(pAuth.getPassword())).getBytes();
            out.println("Authorization: " + pAuthType + " " + BASE64.encode(userPass));
        }
        for (Map.Entry<Object, Object> property : pProps.entrySet()) {
            out.println(property.getKey() + ": " + property.getValue());
        }
        out.println();
    }

    private static int findEndOfHeader(byte[] pBytes, int pEnd) {
        byte[] header = HTTP_HEADER_END.getBytes();
        for (int i = 0; i < pEnd - 4; ++i) {
            if (pBytes[i] != header[0] || pBytes[i + 1] != header[1] || pBytes[i + 2] != header[2] || pBytes[i + 3] != header[3]) continue;
            return i + 4;
        }
        if (pEnd - 1 >= 0 && pBytes[pEnd - 1] == header[0]) {
            return -2;
        }
        if (pEnd - 2 >= 0 && pBytes[pEnd - 2] == header[0] && pBytes[pEnd - 1] == header[1]) {
            return -3;
        }
        if (pEnd - 3 >= 0 && pBytes[pEnd - 3] == header[0] && pBytes[pEnd - 2] == header[1] && pBytes[pEnd - 1] == header[2]) {
            return -4;
        }
        return -1;
    }

    private static InputStream detatchResponseHeader(BufferedInputStream pIS) throws IOException {
        int length;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        pIS.mark(8192);
        byte[] buffer = new byte[8192];
        while ((length = pIS.read(buffer)) != -1) {
            int headerEnd = HttpURLConnection.findEndOfHeader(buffer, length);
            if (headerEnd >= 0) {
                bytes.write(buffer, 0, headerEnd);
                pIS.reset();
                pIS.skip(headerEnd);
                break;
            }
            if (headerEnd < -1) {
                bytes.write(buffer, 0, length - 4);
                pIS.reset();
                pIS.skip(length - 4);
            } else {
                bytes.write(buffer, 0, length);
            }
            pIS.mark(8192);
        }
        return new ByteArrayInputStream(bytes.toByteArray());
    }

    private static Properties parseHeaderFields(String[] pHeaders) {
        Properties headers = new Properties();
        for (String header : pHeaders) {
            int split = header.indexOf(":");
            if (split <= 0) continue;
            String field = header.substring(0, split);
            String value = header.substring(split + 1);
            headers.setProperty(StringUtil.toLowerCase(field), value.trim());
        }
        return headers;
    }

    private static String[] parseResponseHeader(InputStream pIS) throws IOException {
        String header;
        ArrayList<String> headers = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(pIS));
        while ((header = in.readLine()) != null) {
            headers.add(header);
        }
        return headers.toArray(new String[headers.size()]);
    }

    protected static class ChunkedInputStream
    extends FilterInputStream {
        private int mAvailableInCurrentChunk = 0;

        protected ChunkedInputStream(InputStream pIS) {
            super(pIS);
            if (pIS == null) {
                throw new IllegalArgumentException("InputStream may not be null!");
            }
        }

        public int available() throws IOException {
            int realAvail;
            if (this.mAvailableInCurrentChunk == 0) {
                this.mAvailableInCurrentChunk = this.parseChunkSize();
            }
            return this.mAvailableInCurrentChunk < (realAvail = this.in.available()) ? this.mAvailableInCurrentChunk : realAvail;
        }

        public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
            if (this.mAvailableInCurrentChunk == -1) {
                return -1;
            }
            if (this.mAvailableInCurrentChunk == 0) {
                this.mAvailableInCurrentChunk = this.parseChunkSize();
                return this.read(pBytes, pOffset, pLength);
            }
            if (this.mAvailableInCurrentChunk < pLength) {
                int read = this.in.read(pBytes, pOffset, this.mAvailableInCurrentChunk);
                this.mAvailableInCurrentChunk -= read;
                return read;
            }
            int read = this.in.read(pBytes, pOffset, pLength);
            this.mAvailableInCurrentChunk -= read;
            return read;
        }

        public int read() throws IOException {
            if (this.mAvailableInCurrentChunk == -1) {
                return -1;
            }
            if (this.mAvailableInCurrentChunk == 0) {
                this.mAvailableInCurrentChunk = this.parseChunkSize();
                return this.read();
            }
            --this.mAvailableInCurrentChunk;
            return this.in.read();
        }

        protected int parseChunkSize() throws IOException {
            int b;
            StringBuilder buf = new StringBuilder();
            while ((b = this.in.read()) > 0 && (b != 13 || this.in.read() != 10)) {
                buf.append((char)b);
            }
            String line = buf.toString();
            if (line.length() == 0) {
                return 0;
            }
            int spIdx = line.indexOf(32);
            int size = Integer.parseInt(spIdx >= 0 ? line.substring(0, spIdx) : line, 16);
            if (size == 0) {
                return -1;
            }
            return size;
        }
    }

    protected static class FixedLengthInputStream
    extends FilterInputStream {
        private int mBytesLeft = 0;

        protected FixedLengthInputStream(InputStream pIS, int pLength) {
            super(pIS);
            this.mBytesLeft = pLength;
        }

        public int available() throws IOException {
            int available = this.in.available();
            return available < this.mBytesLeft ? available : this.mBytesLeft;
        }

        public int read() throws IOException {
            if (this.mBytesLeft-- > 0) {
                return this.in.read();
            }
            return -1;
        }

        public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
            if (this.mBytesLeft <= 0) {
                return -1;
            }
            if (this.mBytesLeft < pLength) {
                int read = this.in.read(pBytes, pOffset, this.mBytesLeft);
                this.mBytesLeft -= read;
                return read;
            }
            int read = this.in.read(pBytes, pOffset, pLength);
            this.mBytesLeft -= read;
            return read;
        }
    }

    private static interface SocketConnector
    extends Runnable {
        public Socket getSocket() throws IOException;
    }
}

