/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.net;

import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.lang.SystemUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MIMEUtil {
    private static Map<String, List<String>> sExtToMIME = new HashMap<String, List<String>>();
    private static Map<String, List<String>> sUnmodifiableExtToMIME = Collections.unmodifiableMap(sExtToMIME);
    private static Map<String, List<String>> sMIMEToExt = new HashMap<String, List<String>>();
    private static Map<String, List<String>> sUnmodifiableMIMEToExt = Collections.unmodifiableMap(sMIMEToExt);

    private MIMEUtil() {
    }

    public static String getMIMEType(String pFileExt) {
        List<String> types = sExtToMIME.get(StringUtil.toLowerCase(pFileExt));
        return types == null || types.isEmpty() ? null : types.get(0);
    }

    public static List<String> getMIMETypes(String pFileExt) {
        List<String> types = sExtToMIME.get(StringUtil.toLowerCase(pFileExt));
        return MIMEUtil.maskNull(types);
    }

    public static Map<String, List<String>> getMIMETypeMappings() {
        return sUnmodifiableExtToMIME;
    }

    public static String getExtension(String pMIME) {
        String mime = MIMEUtil.bareMIME(StringUtil.toLowerCase(pMIME));
        List<String> extensions = sMIMEToExt.get(mime);
        return extensions == null || extensions.isEmpty() ? null : extensions.get(0);
    }

    public static List<String> getExtensions(String pMIME) {
        String mime = MIMEUtil.bareMIME(StringUtil.toLowerCase(pMIME));
        if (mime.endsWith("/*")) {
            return MIMEUtil.getExtensionForWildcard(mime);
        }
        List<String> extensions = sMIMEToExt.get(mime);
        return MIMEUtil.maskNull(extensions);
    }

    private static List<String> getExtensionForWildcard(String pMIME) {
        String family = pMIME.substring(0, pMIME.length() - 1);
        LinkedHashSet extensions = new LinkedHashSet();
        for (Map.Entry<String, List<String>> mimeToExt : sMIMEToExt.entrySet()) {
            if (!"*/".equals(family) && !mimeToExt.getKey().startsWith(family)) continue;
            extensions.addAll(mimeToExt.getValue());
        }
        return Collections.unmodifiableList(new ArrayList(extensions));
    }

    public static Map<String, List<String>> getExtensionMappings() {
        return sUnmodifiableMIMEToExt;
    }

    static boolean includes(String pTypeFamily, String pType) {
        String type = MIMEUtil.bareMIME(pType);
        return type.equals(pTypeFamily) || "*/*".equals(pTypeFamily) || pTypeFamily.endsWith("/*") && pTypeFamily.startsWith(type.substring(0, type.indexOf(47)));
    }

    public static String bareMIME(String pMIME) {
        int idx;
        if (pMIME != null && (idx = pMIME.indexOf(59)) >= 0) {
            return pMIME.substring(0, idx);
        }
        return pMIME;
    }

    private static List<String> maskNull(List<String> pTypes) {
        return pTypes == null ? Collections.emptyList() : pTypes;
    }

    public static void main(String[] pArgs) {
        if (pArgs.length > 1) {
            String type = pArgs[0];
            String family = pArgs[1];
            boolean incuded = MIMEUtil.includes(family, type);
            System.out.println("Mime type family " + family + (incuded ? " includes " : " does not include ") + "type " + type);
        }
        if (pArgs.length > 0) {
            String str = pArgs[0];
            if (str.indexOf(47) >= 0) {
                String extension = MIMEUtil.getExtension(str);
                System.out.println("Default extension for MIME type '" + str + "' is " + (extension != null ? ": '" + extension + "'" : "unknown") + ".");
                System.out.println("All possible: " + MIMEUtil.getExtensions(str));
            } else {
                String mimeType = MIMEUtil.getMIMEType(str);
                System.out.println("Default MIME type for extension '" + str + "' is " + (mimeType != null ? ": '" + mimeType + "'" : "unknown") + ".");
                System.out.println("All possible: " + MIMEUtil.getMIMETypes(str));
            }
            return;
        }
        Set<String> set = sMIMEToExt.keySet();
        Object[] mimeTypes = new String[set.size()];
        int i = 0;
        for (String mime : set) {
            mimeTypes[i] = mime;
            ++i;
        }
        Arrays.sort(mimeTypes);
        System.out.println("Known MIME types (" + mimeTypes.length + "):");
        for (int j = 0; j < mimeTypes.length; ++j) {
            Object mimeType = mimeTypes[j];
            if (j != 0) {
                System.out.print(", ");
            }
            System.out.print((String)mimeType);
        }
        System.out.println("\n");
        set = sExtToMIME.keySet();
        Object[] extensions = new String[set.size()];
        i = 0;
        for (String ext : set) {
            extensions[i] = ext;
            ++i;
        }
        Arrays.sort(extensions);
        System.out.println("Known file types (" + extensions.length + "):");
        for (int j = 0; j < extensions.length; ++j) {
            Object extension = extensions[j];
            if (j != 0) {
                System.out.print(", ");
            }
            System.out.print((String)extension);
        }
        System.out.println();
    }

    static {
        try {
            Properties mappings = SystemUtil.loadProperties(MIMEUtil.class);
            for (Map.Entry<Object, Object> entry : mappings.entrySet()) {
                String extStr = StringUtil.toLowerCase((String)entry.getKey());
                List<String> extensions = Collections.unmodifiableList(Arrays.asList(StringUtil.toStringArray(extStr, ";, ")));
                String typeStr = StringUtil.toLowerCase((String)entry.getValue());
                List<String> mimeTypes = Collections.unmodifiableList(Arrays.asList(StringUtil.toStringArray(typeStr, ";, ")));
                for (String extension : extensions) {
                    sExtToMIME.put(extension, mimeTypes);
                }
                for (String mimeType : mimeTypes) {
                    sMIMEToExt.put(mimeType, extensions);
                }
            }
        }
        catch (IOException e) {
            System.err.println("Could not read properties for MIMEUtil: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

