/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.net;

import com.twelvemonkeys.net.AuthKey;
import com.twelvemonkeys.net.AuthenticatorFilter;
import com.twelvemonkeys.net.NetUtil;
import com.twelvemonkeys.net.PasswordAuthenticator;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Hashtable;

public class SimpleAuthenticator
extends Authenticator {
    private static SimpleAuthenticator sInstance = null;
    private static boolean sInitialized = false;
    private static final String MAGIC = "magic";
    private static final int FOURTYTWO = 42;
    public static final String BASIC = "Basic";
    protected Hashtable mPasswordAuthentications = new Hashtable();
    protected Hashtable mAuthenticators = new Hashtable();

    private SimpleAuthenticator() {
    }

    public static synchronized SimpleAuthenticator getInstance() {
        if (!sInitialized) {
            sInstance = new SimpleAuthenticator();
            Authenticator.setDefault(sInstance);
            PasswordAuthentication pa = Authenticator.requestPasswordAuthentication(null, 42, null, null, MAGIC);
            if (pa == null || !MAGIC.equals(pa.getUserName()) || !"42".equals(new String(pa.getPassword()))) {
                sInstance = null;
            }
            sInitialized = true;
        }
        return sInstance;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        if (!sInitialized && MAGIC.equals(this.getRequestingScheme()) && this.getRequestingPort() == 42) {
            return new PasswordAuthentication(MAGIC, "42".toCharArray());
        }
        return (PasswordAuthentication)this.mPasswordAuthentications.get(new AuthKey(this.getRequestingSite(), this.getRequestingPort(), this.getRequestingProtocol(), this.getRequestingPrompt(), this.getRequestingScheme()));
    }

    public PasswordAuthentication registerPasswordAuthentication(URL pURL, PasswordAuthentication pPA) {
        return this.registerPasswordAuthentication(NetUtil.createInetAddressFromURL(pURL), pURL.getPort(), pURL.getProtocol(), null, BASIC, pPA);
    }

    public PasswordAuthentication registerPasswordAuthentication(InetAddress pAddress, int pPort, String pProtocol, String pPrompt, String pScheme, PasswordAuthentication pPA) {
        return this.mPasswordAuthentications.put(new AuthKey(pAddress, pPort, pProtocol, pPrompt, pScheme), pPA);
    }

    public PasswordAuthentication unregisterPasswordAuthentication(URL pURL) {
        return this.unregisterPasswordAuthentication(NetUtil.createInetAddressFromURL(pURL), pURL.getPort(), pURL.getProtocol(), null, BASIC);
    }

    public PasswordAuthentication unregisterPasswordAuthentication(InetAddress pAddress, int pPort, String pProtocol, String pPrompt, String pScheme) {
        return (PasswordAuthentication)this.mPasswordAuthentications.remove(new AuthKey(pAddress, pPort, pProtocol, pPrompt, pScheme));
    }

    public void registerPasswordAuthenticator(PasswordAuthenticator pPA, AuthenticatorFilter pFilter) {
        this.mAuthenticators.put(pPA, pFilter);
    }

    public void unregisterPasswordAuthenticator(PasswordAuthenticator pPA) {
        this.mAuthenticators.remove(pPA);
    }
}

