/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.AbstractDecoratedMap;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedMap<K, V>
extends AbstractDecoratedMap<K, V>
implements Serializable {
    transient LinkedEntry<K, V> mHead;
    protected final boolean mAccessOrder;

    public LinkedMap() {
        this(null, false);
    }

    public LinkedMap(boolean pAccessOrder) {
        this(null, pAccessOrder);
    }

    public LinkedMap(Map<? extends K, ? extends V> pContents) {
        this(pContents, false);
    }

    public LinkedMap(Map<? extends K, ? extends V> pContents, boolean pAccessOrder) {
        super(pContents);
        this.mAccessOrder = pAccessOrder;
    }

    public LinkedMap(Map<K, Map.Entry<K, V>> pBacking, Map<? extends K, ? extends V> pContents) {
        this(pBacking, pContents, false);
    }

    public LinkedMap(Map<K, Map.Entry<K, V>> pBacking, Map<? extends K, ? extends V> pContents, boolean pAccessOrder) {
        super(pBacking, pContents);
        this.mAccessOrder = pAccessOrder;
    }

    @Override
    protected void init() {
        this.mHead = new LinkedEntry<K, V>(null, null, null){

            @Override
            void addBefore(LinkedEntry pExisting) {
                throw new Error();
            }

            @Override
            void remove() {
                throw new Error();
            }

            @Override
            public void recordAccess(Map pMap) {
                throw new Error();
            }

            @Override
            public void recordRemoval(Map pMap) {
                throw new Error();
            }

            public void recordRemoval() {
                throw new Error();
            }

            @Override
            public V getValue() {
                throw new Error();
            }

            @Override
            public V setValue(V pValue) {
                throw new Error();
            }

            @Override
            public K getKey() {
                throw new Error();
            }

            @Override
            public String toString() {
                return "head";
            }
        };
        this.mHead.mNext = this.mHead;
        this.mHead.mPrevious = this.mHead.mNext;
    }

    @Override
    public boolean containsValue(Object pValue) {
        if (pValue == null) {
            LinkedEntry e = this.mHead.mNext;
            while (e != this.mHead) {
                if (e.mValue == null) {
                    return true;
                }
                e = e.mNext;
            }
        } else {
            LinkedEntry e = this.mHead.mNext;
            while (e != this.mHead) {
                if (pValue.equals(e.mValue)) {
                    return true;
                }
                e = e.mNext;
            }
        }
        return false;
    }

    @Override
    protected Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    @Override
    protected Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    @Override
    protected Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public V get(Object pKey) {
        LinkedEntry entry = (LinkedEntry)this.mEntries.get(pKey);
        if (entry != null) {
            entry.recordAccess(this);
            return (V)entry.mValue;
        }
        return null;
    }

    @Override
    public V remove(Object pKey) {
        LinkedEntry entry = (LinkedEntry)this.mEntries.remove(pKey);
        if (entry != null) {
            entry.remove();
            ++this.mModCount;
            return (V)entry.mValue;
        }
        return null;
    }

    @Override
    public V put(K pKey, V pValue) {
        Object oldValue;
        Map.Entry<K, V> entry = (LinkedEntry)this.mEntries.get(pKey);
        if (entry == null) {
            oldValue = null;
            LinkedEntry eldest = this.mHead.mNext;
            if (this.removeEldestEntry(eldest)) {
                this.removeEntry(eldest);
            }
            entry = this.createEntry((Object)pKey, (Object)pValue);
            ((LinkedEntry)entry).addBefore(this.mHead);
            this.mEntries.put(pKey, entry);
        } else {
            oldValue = ((LinkedEntry)entry).mValue;
            ((LinkedEntry)entry).mValue = pValue;
            ((LinkedEntry)entry).recordAccess(this);
        }
        ++this.mModCount;
        return (V)oldValue;
    }

    @Override
    LinkedEntry<K, V> createEntry(K pKey, V pValue) {
        return new LinkedEntry<K, V>(pKey, pValue, null);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LinkedMap map = (LinkedMap)super.clone();
        return map;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> pEldest) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LinkedEntry<K, V>
    extends AbstractDecoratedMap.BasicEntry<K, V>
    implements Serializable {
        LinkedEntry<K, V> mPrevious;
        LinkedEntry<K, V> mNext;

        LinkedEntry(K pKey, V pValue, LinkedEntry<K, V> pNext) {
            super(pKey, pValue);
            this.mNext = pNext;
        }

        void addBefore(LinkedEntry<K, V> pExisting) {
            this.mNext = pExisting;
            this.mPrevious = pExisting.mPrevious;
            this.mPrevious.mNext = this;
            this.mNext.mPrevious = this;
        }

        void remove() {
            this.mPrevious.mNext = this.mNext;
            this.mNext.mPrevious = this.mPrevious;
        }

        @Override
        protected void recordAccess(Map<K, V> pMap) {
            LinkedMap linkedMap = (LinkedMap)pMap;
            if (linkedMap.mAccessOrder) {
                ++linkedMap.mModCount;
                this.remove();
                this.addBefore(linkedMap.mHead);
            }
        }

        @Override
        protected void recordRemoval(Map<K, V> pMap) {
            this.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends LinkedMapIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends LinkedMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().mValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends LinkedMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().mKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class LinkedMapIterator<E>
    implements Iterator<E> {
        LinkedEntry<K, V> mNextEntry;
        LinkedEntry<K, V> mLastReturned;
        int mExpectedModCount;

        private LinkedMapIterator() {
            this.mNextEntry = LinkedMap.this.mHead.mNext;
            this.mLastReturned = null;
            this.mExpectedModCount = LinkedMap.this.mModCount;
        }

        @Override
        public boolean hasNext() {
            return this.mNextEntry != LinkedMap.this.mHead;
        }

        @Override
        public void remove() {
            if (this.mLastReturned == null) {
                throw new IllegalStateException();
            }
            if (LinkedMap.this.mModCount != this.mExpectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedMap.this.remove(this.mLastReturned.mKey);
            this.mLastReturned = null;
            this.mExpectedModCount = LinkedMap.this.mModCount;
        }

        LinkedEntry<K, V> nextEntry() {
            if (LinkedMap.this.mModCount != this.mExpectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.mNextEntry == LinkedMap.this.mHead) {
                throw new NoSuchElementException();
            }
            this.mLastReturned = this.mNextEntry;
            LinkedEntry e = this.mLastReturned;
            this.mNextEntry = e.mNext;
            return e;
        }
    }
}

