/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.MinutesFormatter;
import com.twelvemonkeys.util.SecondsFormatter;
import com.twelvemonkeys.util.TextFormatter;
import com.twelvemonkeys.util.Time;
import com.twelvemonkeys.util.TimeFormatter;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.StringTokenizer;
import java.util.Vector;

public class TimeFormat
extends Format {
    static final String MINUTE = "m";
    static final String SECOND = "s";
    static final String TIME = "S";
    static final String ESCAPE = "\\";
    private static final TimeFormat DEFAULT_FORMAT = new TimeFormat("m:ss");
    protected String mFormatString = null;
    protected TimeFormatter[] mFormatter;

    static void main(String[] argv) {
        Time time = null;
        TimeFormat in = null;
        TimeFormat out = null;
        if (argv.length >= 3) {
            System.out.println("Creating out TimeFormat: \"" + argv[2] + "\"");
            out = new TimeFormat(argv[2]);
        }
        if (argv.length >= 2) {
            System.out.println("Creating in TimeFormat: \"" + argv[1] + "\"");
            in = new TimeFormat(argv[1]);
        } else {
            System.out.println("Using default format for in");
            in = DEFAULT_FORMAT;
        }
        if (out == null) {
            out = in;
        }
        if (argv.length >= 1) {
            System.out.println("Parsing: \"" + argv[0] + "\" with format \"" + in.mFormatString + "\"");
            time = in.parse(argv[0]);
        } else {
            time = new Time();
        }
        System.out.println("Time is \"" + out.format(time) + "\" according to format \"" + out.mFormatString + "\"");
    }

    public TimeFormat(String pStr) {
        this.mFormatString = pStr;
        Vector<TimeFormatter> formatter = new Vector<TimeFormatter>();
        StringTokenizer tok = new StringTokenizer(pStr, "\\msS", true);
        String previous = null;
        String current = null;
        int previousCount = 0;
        while (tok.hasMoreElements()) {
            current = tok.nextToken();
            if (previous != null && previous.equals(ESCAPE)) {
                current = (current != null ? current : "") + (tok.hasMoreElements() ? tok.nextToken() : "");
                previous = null;
                previousCount = 0;
            }
            if (previous == null || previous.equals(current)) {
                ++previousCount;
                previous = current;
                continue;
            }
            if (previous.equals(MINUTE)) {
                formatter.add(new MinutesFormatter(previousCount));
            } else if (previous.equals(SECOND)) {
                formatter.add(new SecondsFormatter(previousCount));
            } else if (previous.equals(TIME)) {
                formatter.add(new SecondsFormatter(-1));
            } else {
                formatter.add(new TextFormatter(previous));
            }
            previousCount = 1;
            previous = current;
        }
        if (previous != null) {
            if (previous.equals(MINUTE)) {
                formatter.add(new MinutesFormatter(previousCount));
            } else if (previous.equals(SECOND)) {
                formatter.add(new SecondsFormatter(previousCount));
            } else if (previous.equals(TIME)) {
                formatter.add(new SecondsFormatter(-1));
            } else {
                formatter.add(new TextFormatter(previous));
            }
        }
        this.mFormatter = formatter.toArray(new TimeFormatter[formatter.size()]);
    }

    public static TimeFormat getInstance() {
        return DEFAULT_FORMAT;
    }

    public String getFormatString() {
        return this.mFormatString;
    }

    public StringBuffer format(Object pObj, StringBuffer pToAppendTo, FieldPosition pPos) {
        if (!(pObj instanceof Time)) {
            throw new IllegalArgumentException("Must be instance of " + Time.class);
        }
        return pToAppendTo.append(this.format(pObj));
    }

    public String format(Time pTime) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.mFormatter.length; ++i) {
            buf.append(this.mFormatter[i].format(pTime));
        }
        return buf.toString();
    }

    public Object parseObject(String pStr, ParsePosition pStatus) {
        Time t = this.parse(pStr);
        pStatus.setIndex(pStr.length());
        return t;
    }

    public Time parse(String pStr) {
        Time time = new Time();
        int sec = 0;
        int min = 0;
        int pos = 0;
        int skip = 0;
        boolean onlyUseSeconds = false;
        for (int i = 0; i < this.mFormatter.length && pos + skip < pStr.length(); ++i) {
            pos += skip;
            if (this.mFormatter[i] instanceof MinutesFormatter) {
                if (i + 1 < this.mFormatter.length && this.mFormatter[i + 1] instanceof TextFormatter) {
                    skip = pStr.indexOf(((TextFormatter)this.mFormatter[i + 1]).mText, pos);
                    if (skip < 0) {
                        skip = pStr.length();
                    }
                } else {
                    skip = i + 1 >= this.mFormatter.length ? pStr.length() : this.mFormatter[i].mDigits;
                }
                if (skip <= pos) continue;
                min = Integer.parseInt(pStr.substring(pos, skip));
                continue;
            }
            if (this.mFormatter[i] instanceof SecondsFormatter) {
                if (this.mFormatter[i].mDigits == -1) {
                    if (i + 1 < this.mFormatter.length && this.mFormatter[i + 1] instanceof TextFormatter) {
                        skip = pStr.indexOf(((TextFormatter)this.mFormatter[i + 1]).mText, pos);
                    } else if (i + 1 >= this.mFormatter.length) {
                        skip = pStr.length();
                    } else {
                        skip = 0;
                        continue;
                    }
                    sec = Integer.parseInt(pStr.substring(pos, skip));
                    onlyUseSeconds = true;
                    break;
                }
                skip = i + 1 < this.mFormatter.length && this.mFormatter[i + 1] instanceof TextFormatter ? pStr.indexOf(((TextFormatter)this.mFormatter[i + 1]).mText, pos) : (i + 1 >= this.mFormatter.length ? pStr.length() : this.mFormatter[i].mDigits);
                sec = Integer.parseInt(pStr.substring(pos, skip));
                continue;
            }
            if (!(this.mFormatter[i] instanceof TextFormatter)) continue;
            skip = this.mFormatter[i].mDigits;
        }
        if (!onlyUseSeconds) {
            time.setMinutes(min);
        }
        time.setSeconds(sec);
        return time;
    }
}

