/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.AbstractDecoratedMap;
import com.twelvemonkeys.util.ExpiringMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeoutMap<K, V>
extends AbstractDecoratedMap<K, V>
implements ExpiringMap<K, V>,
Serializable,
Cloneable {
    protected long mExpiryTime = 60000L;
    private volatile long mNextExpiryTime;

    public TimeoutMap() {
    }

    public TimeoutMap(Map<? extends K, ? extends V> pContents) {
        super(pContents);
    }

    public TimeoutMap(long pExpiryTime) {
        this();
        this.mExpiryTime = pExpiryTime;
    }

    public TimeoutMap(Map<K, Map.Entry<K, V>> pBacking, Map<? extends K, ? extends V> pContents, long pExpiryTime) {
        super(pBacking, pContents);
        this.mExpiryTime = pExpiryTime;
    }

    public long getExpiryTime() {
        return this.mExpiryTime;
    }

    public void setExpiryTime(long pExpiryTime) {
        long oldEexpiryTime = this.mExpiryTime;
        this.mExpiryTime = pExpiryTime;
        if (this.mExpiryTime < oldEexpiryTime) {
            this.mNextExpiryTime = 0L;
            this.removeExpiredEntries();
        }
    }

    @Override
    public int size() {
        this.removeExpiredEntries();
        return this.mEntries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() <= 0;
    }

    @Override
    public boolean containsKey(Object pKey) {
        this.removeExpiredEntries();
        return this.mEntries.containsKey(pKey);
    }

    @Override
    public V get(Object pKey) {
        TimedEntry entry = (TimedEntry)this.mEntries.get(pKey);
        if (entry == null) {
            return null;
        }
        if (entry.isExpired()) {
            this.mEntries.remove(pKey);
            this.processRemoved((Map.Entry)entry);
            return null;
        }
        return entry.getValue();
    }

    @Override
    public V put(K pKey, V pValue) {
        Object oldValue;
        Map.Entry entry = (TimedEntry)this.mEntries.get(pKey);
        if (entry == null) {
            oldValue = null;
            entry = this.createEntry((Object)pKey, (Object)pValue);
            this.mEntries.put(pKey, entry);
        } else {
            oldValue = ((TimedEntry)entry).mValue;
            ((TimedEntry)entry).setValue(pValue);
            ((AbstractDecoratedMap.BasicEntry)entry).recordAccess(this);
        }
        this.removeExpiredEntries();
        ++this.mModCount;
        return (V)oldValue;
    }

    @Override
    public V remove(Object pKey) {
        TimedEntry entry = (TimedEntry)this.mEntries.remove(pKey);
        return entry != null ? (V)entry.getValue() : null;
    }

    @Override
    public void clear() {
        this.mEntries.clear();
        this.init();
    }

    @Override
    TimedEntry<K, V> createEntry(K pKey, V pValue) {
        return new TimedEntry<K, V>(pKey, pValue);
    }

    protected void removeExpiredEntries() {
        long now = System.currentTimeMillis();
        if (now > this.mNextExpiryTime) {
            this.removeExpiredEntriesSynced(now);
        }
    }

    private synchronized void removeExpiredEntriesSynced(long pTime) {
        if (pTime > this.mNextExpiryTime) {
            long next;
            this.mNextExpiryTime = next = Long.MAX_VALUE;
            EntryIterator iterator = new EntryIterator();
            while (iterator.hasNext()) {
                TimedEntry entry = (TimedEntry)iterator.next();
                long expires = entry.expires();
                if (expires >= next) continue;
                next = expires;
            }
            this.mNextExpiryTime = next;
        }
    }

    @Override
    public Collection<V> values() {
        this.removeExpiredEntries();
        return super.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.removeExpiredEntries();
        return super.entrySet();
    }

    @Override
    public Set<K> keySet() {
        this.removeExpiredEntries();
        return super.keySet();
    }

    @Override
    protected Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    @Override
    protected Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    @Override
    protected Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public void processRemoved(Map.Entry pRemoved) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TimedEntry<K, V>
    extends AbstractDecoratedMap.BasicEntry<K, V> {
        private long mTimestamp;

        TimedEntry(K pKey, V pValue) {
            super(pKey, pValue);
            this.mTimestamp = System.currentTimeMillis();
        }

        @Override
        public V setValue(V pValue) {
            this.mTimestamp = System.currentTimeMillis();
            return super.setValue(pValue);
        }

        final boolean isExpired() {
            return this.isExpiredBy(System.currentTimeMillis());
        }

        final boolean isExpiredBy(long pTime) {
            return pTime > this.expires();
        }

        final long expires() {
            return this.mTimestamp + TimeoutMap.this.mExpiryTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends TimeoutMapIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends TimeoutMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().mValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends TimeoutMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().mKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TimeoutMapIterator<E>
    implements Iterator<E> {
        Iterator<Map.Entry<K, Map.Entry<K, V>>> mIterator;
        AbstractDecoratedMap.BasicEntry<K, V> mNext;
        long mNow;

        private TimeoutMapIterator() {
            this.mIterator = TimeoutMap.this.mEntries.entrySet().iterator();
            this.mNow = System.currentTimeMillis();
        }

        @Override
        public void remove() {
            this.mNext = null;
            this.mIterator.remove();
        }

        @Override
        public boolean hasNext() {
            if (this.mNext != null) {
                return true;
            }
            while (this.mNext == null && this.mIterator.hasNext()) {
                Map.Entry entry = this.mIterator.next();
                TimedEntry timed = (TimedEntry)entry.getValue();
                if (timed.isExpiredBy(this.mNow)) {
                    this.mIterator.remove();
                    TimeoutMap.this.processRemoved((Map.Entry)timed);
                    continue;
                }
                this.mNext = timed;
                return true;
            }
            return false;
        }

        AbstractDecoratedMap.BasicEntry<K, V> nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AbstractDecoratedMap.BasicEntry entry = this.mNext;
            this.mNext = null;
            return entry;
        }
    }
}

