/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedMap<K extends Key, V>
implements Map<K, V>,
Serializable {
    protected Map<K, V> mEntries;

    public TypedMap() {
        this.mEntries = new HashMap();
    }

    public TypedMap(Map<? extends K, ? extends V> pMap) {
        this();
        if (pMap != null) {
            this.putAll(pMap);
        }
    }

    public TypedMap(Map<? extends K, ? extends V> pBacking, boolean pUseElements) {
        if (pBacking == null) {
            throw new IllegalArgumentException("backing == null");
        }
        this.mEntries = pBacking;
        if (pUseElements) {
            this.putAll(pBacking);
        } else if (this.mEntries.size() > 0) {
            this.mEntries.clear();
        }
    }

    @Override
    public int size() {
        return this.mEntries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mEntries.isEmpty();
    }

    @Override
    public boolean containsKey(Object pKey) {
        return this.mEntries.containsKey(pKey);
    }

    @Override
    public boolean containsValue(Object pValue) {
        return this.mEntries.containsValue(pValue);
    }

    @Override
    public V get(Object pKey) {
        return this.mEntries.get(pKey);
    }

    @Override
    public V put(K pKey, V pValue) {
        if (!pKey.isCompatibleValue(pValue)) {
            throw new IllegalArgumentException("incompatible value for key");
        }
        return this.mEntries.put(pKey, pValue);
    }

    @Override
    public V remove(Object pKey) {
        return this.mEntries.remove(pKey);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> pMap) {
        for (Map.Entry<K, V> e : pMap.entrySet()) {
            this.put((K)((Key)e.getKey()), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.mEntries.clear();
    }

    @Override
    public Collection<V> values() {
        return this.mEntries.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mEntries.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return this.mEntries.keySet();
    }

    public static abstract class AbstractKey
    implements Key,
    Serializable {
        private final String mStringRep;

        public AbstractKey(String pName) {
            if (pName == null) {
                throw new IllegalArgumentException("name == null");
            }
            this.mStringRep = this.getClass().getName() + '[' + pName + ']';
        }

        public AbstractKey() {
            this("null");
        }

        public String toString() {
            return this.mStringRep;
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass() == this.getClass() && this.mStringRep.equals(((AbstractKey)obj).mStringRep);
        }

        public int hashCode() {
            return this.mStringRep.hashCode();
        }
    }

    public static interface Key {
        public boolean isCompatibleValue(Object var1);
    }
}

