/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakWeakMap<K, V>
extends WeakHashMap<K, V> {
    public WeakWeakMap() {
    }

    public WeakWeakMap(int pInitialCapacity) {
        super(pInitialCapacity);
    }

    public WeakWeakMap(int pInitialCapacity, float pLoadFactor) {
        super(pInitialCapacity, pLoadFactor);
    }

    public WeakWeakMap(Map<? extends K, ? extends V> pMap) {
        super(pMap);
    }

    @Override
    public V put(K pKey, V pValue) {
        return (V)super.put(pKey, new WeakReference<V>(pValue));
    }

    @Override
    public V get(Object pKey) {
        WeakReference ref = (WeakReference)super.get(pKey);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public V remove(Object pKey) {
        WeakReference ref = (WeakReference)super.remove(pKey);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public boolean containsValue(Object pValue) {
        for (V value : this.values()) {
            if (pValue != value && (value == null || !value.equals(pValue))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> pMap) {
        for (Map.Entry<K, V> entry : pMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    final Iterator<Map.Entry<K, WeakReference<V>>> mIterator;
                    {
                        this.mIterator = WeakWeakMap.super.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new Map.Entry<K, V>(){
                            final Map.Entry<K, WeakReference<V>> mEntry;
                            {
                                this.mEntry = mIterator.next();
                            }

                            @Override
                            public K getKey() {
                                return this.mEntry.getKey();
                            }

                            @Override
                            public V getValue() {
                                WeakReference ref = this.mEntry.getValue();
                                return ref.get();
                            }

                            @Override
                            public V setValue(V pValue) {
                                WeakReference ref = this.mEntry.setValue(new WeakReference(pValue));
                                return ref != null ? (Object)ref.get() : null;
                            }

                            @Override
                            public boolean equals(Object obj) {
                                return ((Object)this.mEntry).equals(obj);
                            }

                            @Override
                            public int hashCode() {
                                return ((Object)this.mEntry).hashCode();
                            }

                            public String toString() {
                                return this.mEntry.toString();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.mIterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return WeakWeakMap.this.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<WeakReference<V>> mIterator;
                    {
                        this.mIterator = WeakWeakMap.super.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mIterator.hasNext();
                    }

                    @Override
                    public V next() {
                        WeakReference ref = this.mIterator.next();
                        return ref.get();
                    }

                    @Override
                    public void remove() {
                        this.mIterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return WeakWeakMap.this.size();
            }
        };
    }
}

