/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.convert;

import com.twelvemonkeys.lang.BeanUtil;
import com.twelvemonkeys.util.convert.ConversionException;
import com.twelvemonkeys.util.convert.MissingTypeException;
import com.twelvemonkeys.util.convert.PropertyConverter;
import java.lang.reflect.InvocationTargetException;

public final class DefaultConverter
implements PropertyConverter {
    public Object toObject(String pString, Class pType, String pFormat) throws ConversionException {
        if (pString == null) {
            return null;
        }
        if (pType == null) {
            throw new MissingTypeException();
        }
        Class type = pType == Boolean.TYPE ? Boolean.class : pType;
        try {
            Object value = BeanUtil.createInstance(type, (Object)pString);
            if (value == null && (value = BeanUtil.invokeStaticMethod(type, "valueOf", pString)) == null) {
                throw new ConversionException("Could not convert String to " + pType.getName() + ": No constructor " + type.getName() + "(String) or static " + type.getName() + ".valueof(String) method found!");
            }
            return value;
        }
        catch (InvocationTargetException ite) {
            throw new ConversionException(ite.getTargetException());
        }
        catch (RuntimeException rte) {
            throw new ConversionException(rte);
        }
    }

    public String toString(Object pObject, String pFormat) throws ConversionException {
        try {
            return pObject != null ? pObject.toString() : null;
        }
        catch (RuntimeException rte) {
            throw new ConversionException(rte);
        }
    }
}

