/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.transport;

import com.twitter.finagle.Status;
import com.twitter.finagle.netty4.transport.HasExecutor;
import com.twitter.finagle.transport.TransportContext;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import com.twitter.util.Time;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb!B\u0001\u0003\u0005\u0019a!aF\"iC:tW\r\u001c+sC:\u001c\bo\u001c:u\u0007>tG/\u001a=u\u0015\t\u0019A!A\u0005ue\u0006t7\u000f]8si*\u0011QAB\u0001\u0007]\u0016$H/\u001f\u001b\u000b\u0005\u001dA\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u0013)\tq\u0001^<jiR,'OC\u0001\f\u0003\r\u0019w.\\\n\u0004\u00015\u0011\u0002C\u0001\b\u0011\u001b\u0005y!BA\u0002\u0007\u0013\t\trB\u0001\tUe\u0006t7\u000f]8si\u000e{g\u000e^3yiB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\f\u0011\u0006\u001cX\t_3dkR|'\u000f\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u001a\u0003\t\u0019\u0007n\u0001\u0001\u0011\u0005i\tS\"A\u000e\u000b\u0005qi\u0012aB2iC:tW\r\u001c\u0006\u0003=}\tQA\\3uifT\u0011\u0001I\u0001\u0003S>L!AI\u000e\u0003\u000f\rC\u0017M\u001c8fY\")A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"\"AJ\u0014\u0011\u0005M\u0001\u0001\"B\f$\u0001\u0004I\u0002\u0002C\u0015\u0001\u0005\u0004%\tA\u0001\u0016\u0002\r\u0019\f\u0017\u000e\\3e+\u0005Y\u0003C\u0001\u00176\u001b\u0005i#B\u0001\u00180\u0003\u0019\tGo\\7jG*\u0011\u0001'M\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u001a4\u0003\u0011)H/\u001b7\u000b\u0003Q\nAA[1wC&\u0011a'\f\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\ra\u0002\u0001\u0015!\u0003,\u0003\u001d1\u0017-\u001b7fI\u0002B\u0001B\u000f\u0001C\u0002\u0013\u0005!aO\u0001\u0007G2|7/\u001a3\u0016\u0003q\u00022!P B\u001b\u0005q$B\u0001\u001a\t\u0013\t\u0001eHA\u0004Qe>l\u0017n]3\u0011\u0005\tceBA\"J\u001d\t!u)D\u0001F\u0015\t1\u0005$\u0001\u0004=e>|GOP\u0005\u0002\u0011\u0006)1oY1mC&\u0011!jS\u0001\ba\u0006\u001c7.Y4f\u0015\u0005A\u0015BA'O\u0005%!\u0006N]8xC\ndWM\u0003\u0002K\u0017\"1\u0001\u000b\u0001Q\u0001\nq\nqa\u00197pg\u0016$\u0007\u0005\u0003\u0005S\u0001\t\u0007I\u0011\u0001\u0002+\u00035\tGN]3bIf\u001cEn\\:fI\"1A\u000b\u0001Q\u0001\n-\na\"\u00197sK\u0006$\u0017p\u00117pg\u0016$\u0007\u0005C\u0003W\u0001\u0011\u0005q+\u0001\u0004ti\u0006$Xo]\u000b\u00021B\u0011\u0011LW\u0007\u0002\r%\u00111L\u0002\u0002\u0007'R\fG/^:\t\u000bu\u0003A\u0011\u00010\u0002\u000f=t7\t\\8tKV\tq\fE\u0002>A\u0006K!!\u0019 \u0003\r\u0019+H/\u001e:f\u0011\u0015\u0019\u0007\u0001\"\u0001e\u00031awnY1m\u0003\u0012$'/Z:t+\u0005)\u0007C\u00014j\u001b\u00059'B\u000154\u0003\rqW\r^\u0005\u0003U\u001e\u0014QbU8dW\u0016$\u0018\t\u001a3sKN\u001c\b\"\u00027\u0001\t\u0003!\u0017!\u0004:f[>$X-\u00113ee\u0016\u001c8\u000fC\u0004o\u0001\t\u0007I\u0011A8\u0002\u001fA,WM]\"feRLg-[2bi\u0016,\u0012\u0001\u001d\t\u0004cJ$X\"A&\n\u0005M\\%AB(qi&|g\u000e\u0005\u0002vu6\taO\u0003\u0002xq\u0006!1-\u001a:u\u0015\tI8'\u0001\u0005tK\u000e,(/\u001b;z\u0013\tYhOA\u0006DKJ$\u0018NZ5dCR,\u0007BB?\u0001A\u0003%\u0001/\u0001\tqK\u0016\u00148)\u001a:uS\u001aL7-\u0019;fA!1q\u0010\u0001C\u0001\u0003\u0003\tQa\u00197pg\u0016$B!a\u0001\u0002\fA!Q\bYA\u0003!\r\t\u0018qA\u0005\u0004\u0003\u0013Y%\u0001B+oSRDq!!\u0004\u007f\u0001\u0004\ty!\u0001\u0005eK\u0006$G.\u001b8f!\ri\u0014\u0011C\u0005\u0004\u0003'q$\u0001\u0002+j[\u0016Dq!a\u0006\u0001\t\u0003\tI\"\u0001\u0005fq\u0016\u001cW\u000f^8s+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005}Q\"A\u0018\n\u0007\u0005\u0005rF\u0001\u0005Fq\u0016\u001cW\u000f^8s\u0001")
public final class ChannelTransportContext
extends TransportContext
implements HasExecutor {
    private final Channel ch;
    private final AtomicBoolean failed;
    private final Promise<Throwable> closed;
    private final AtomicBoolean alreadyClosed;
    private final Option<Certificate> peerCertificate;

    public AtomicBoolean failed() {
        return this.failed;
    }

    public Promise<Throwable> closed() {
        return this.closed;
    }

    public AtomicBoolean alreadyClosed() {
        return this.alreadyClosed;
    }

    public Status status() {
        return this.failed().get() || !this.ch.isOpen() ? Status.Closed$.MODULE$ : Status.Open$.MODULE$;
    }

    public Future<Throwable> onClose() {
        return this.closed();
    }

    public SocketAddress localAddress() {
        return this.ch.localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.ch.remoteAddress();
    }

    public Option<Certificate> peerCertificate() {
        return this.peerCertificate;
    }

    public Future<BoxedUnit> close(Time deadline) {
        Object object = this.alreadyClosed().compareAndSet(false, true) && this.ch.isOpen() ? this.ch.close() : BoxedUnit.UNIT;
        return this.closed().unit();
    }

    @Override
    public Executor executor() {
        return this.ch.eventLoop();
    }

    private static final Option liftedTree1$1(SslHandler x1$1) {
        Option option;
        try {
            option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x1$1.engine().getSession().getPeerCertificates())).headOption();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            option = none$;
        }
        return option;
    }

    public ChannelTransportContext(Channel ch) {
        this.ch = ch;
        this.failed = new AtomicBoolean(false);
        this.closed = new Promise();
        this.alreadyClosed = new AtomicBoolean(false);
        SslHandler sslHandler = (SslHandler)ch.pipeline().get(SslHandler.class);
        Object object = sslHandler == null ? None$.MODULE$ : ChannelTransportContext.liftedTree1$1(sslHandler);
        this.peerCertificate = object;
    }
}

