/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.ssl.client;

import com.twitter.finagle.Address;
import com.twitter.finagle.netty4.param.Allocator;
import com.twitter.finagle.netty4.param.Allocator$;
import com.twitter.finagle.netty4.ssl.client.Netty4ClientSslConfigurations$;
import com.twitter.finagle.ssl.ApplicationProtocols;
import com.twitter.finagle.ssl.CipherSuites;
import com.twitter.finagle.ssl.Engine;
import com.twitter.finagle.ssl.KeyCredentials;
import com.twitter.finagle.ssl.Protocols;
import com.twitter.finagle.ssl.SslConfigurationException$;
import com.twitter.finagle.ssl.TrustCredentials;
import com.twitter.finagle.ssl.client.SslClientConfiguration;
import com.twitter.finagle.ssl.client.SslClientConfiguration$;
import com.twitter.finagle.ssl.client.SslClientEngineFactory;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class ExternalClientEngineFactory$
extends SslClientEngineFactory {
    public static ExternalClientEngineFactory$ MODULE$;
    private final ByteBufAllocator allocator;
    private final boolean forceJdk;
    private final ApplicationProtocols.Supported http2AppProtocols;
    private final SslClientConfiguration withValidationConfig;
    private final SslClientConfiguration withoutValidationConfig;
    private final SslClientConfiguration withValidation2Config;
    private final SslClientConfiguration withoutValidation2Config;
    private final SslContext withValidationContext;
    private final SslContext withoutValidationContext;
    private final SslContext withValidation2Context;
    private final SslContext withoutValidation2Context;

    static {
        new ExternalClientEngineFactory$();
    }

    private ByteBufAllocator allocator() {
        return this.allocator;
    }

    private boolean forceJdk() {
        return this.forceJdk;
    }

    private ApplicationProtocols.Supported http2AppProtocols() {
        return this.http2AppProtocols;
    }

    private SslClientConfiguration withValidationConfig() {
        return this.withValidationConfig;
    }

    private SslClientConfiguration withoutValidationConfig() {
        return this.withoutValidationConfig;
    }

    private SslClientConfiguration withValidation2Config() {
        return this.withValidation2Config;
    }

    private SslClientConfiguration withoutValidation2Config() {
        return this.withoutValidation2Config;
    }

    private SslContext withValidationContext() {
        return this.withValidationContext;
    }

    private SslContext withoutValidationContext() {
        return this.withoutValidationContext;
    }

    private SslContext withValidation2Context() {
        return this.withValidation2Context;
    }

    private SslContext withoutValidation2Context() {
        return this.withoutValidation2Context;
    }

    private boolean usingHttp2(SslClientConfiguration config) {
        boolean bl;
        ApplicationProtocols applicationProtocols = config.applicationProtocols();
        if (applicationProtocols instanceof ApplicationProtocols.Supported) {
            ApplicationProtocols.Supported supported = (ApplicationProtocols.Supported)applicationProtocols;
            Seq supported2 = supported.appProtocols();
            bl = supported2.contains((Object)"h2");
        } else {
            bl = false;
        }
        return bl;
    }

    private SslContext selectContext(SslClientConfiguration config) {
        SslContext sslContext;
        TrustCredentials trustCredentials = config.trustCredentials();
        if (TrustCredentials.Unspecified$.MODULE$.equals(trustCredentials)) {
            sslContext = this.usingHttp2(config) ? this.withValidation2Context() : this.withValidationContext();
        } else if (TrustCredentials.Insecure$.MODULE$.equals(trustCredentials)) {
            sslContext = this.usingHttp2(config) ? this.withoutValidation2Context() : this.withoutValidationContext();
        } else {
            throw SslConfigurationException$.MODULE$.notSupported("Unknown TrustCredentials value", "ExternalClientEngineFactory");
        }
        return sslContext;
    }

    public Engine apply(Address address, SslClientConfiguration config) {
        SslContext context = this.selectContext(config);
        return Netty4ClientSslConfigurations$.MODULE$.createClientEngine(address, config, context, this.allocator());
    }

    private ExternalClientEngineFactory$() {
        MODULE$ = this;
        this.allocator = ((Allocator)Allocator$.MODULE$.allocatorParam().default()).allocator();
        this.forceJdk = !OpenSsl.isAvailable();
        this.http2AppProtocols = new ApplicationProtocols.Supported((Seq)new .colon.colon((Object)"h2", (List)new .colon.colon((Object)"http/1.1", (List)Nil$.MODULE$)));
        this.withValidationConfig = new SslClientConfiguration(SslClientConfiguration$.MODULE$.apply$default$1(), SslClientConfiguration$.MODULE$.apply$default$2(), SslClientConfiguration$.MODULE$.apply$default$3(), SslClientConfiguration$.MODULE$.apply$default$4(), SslClientConfiguration$.MODULE$.apply$default$5(), SslClientConfiguration$.MODULE$.apply$default$6(), SslClientConfiguration$.MODULE$.apply$default$7(), SslClientConfiguration$.MODULE$.apply$default$8());
        TrustCredentials.Insecure$ x$1 = TrustCredentials.Insecure$.MODULE$;
        Option x$2 = SslClientConfiguration$.MODULE$.apply$default$1();
        Option x$3 = SslClientConfiguration$.MODULE$.apply$default$2();
        KeyCredentials x$4 = SslClientConfiguration$.MODULE$.apply$default$3();
        CipherSuites x$5 = SslClientConfiguration$.MODULE$.apply$default$5();
        Protocols x$6 = SslClientConfiguration$.MODULE$.apply$default$6();
        ApplicationProtocols x$7 = SslClientConfiguration$.MODULE$.apply$default$7();
        boolean x$8 = SslClientConfiguration$.MODULE$.apply$default$8();
        this.withoutValidationConfig = new SslClientConfiguration(x$2, x$3, x$4, (TrustCredentials)x$1, x$5, x$6, x$7, x$8);
        ApplicationProtocols.Supported x$9 = this.http2AppProtocols();
        Option x$10 = this.withValidationConfig().copy$default$1();
        Option x$11 = this.withValidationConfig().copy$default$2();
        KeyCredentials x$12 = this.withValidationConfig().copy$default$3();
        TrustCredentials x$13 = this.withValidationConfig().copy$default$4();
        CipherSuites x$14 = this.withValidationConfig().copy$default$5();
        Protocols x$15 = this.withValidationConfig().copy$default$6();
        boolean x$16 = this.withValidationConfig().copy$default$8();
        this.withValidation2Config = this.withValidationConfig().copy(x$10, x$11, x$12, x$13, x$14, x$15, (ApplicationProtocols)x$9, x$16);
        ApplicationProtocols.Supported x$17 = this.http2AppProtocols();
        Option x$18 = this.withoutValidationConfig().copy$default$1();
        Option x$19 = this.withoutValidationConfig().copy$default$2();
        KeyCredentials x$20 = this.withoutValidationConfig().copy$default$3();
        TrustCredentials x$21 = this.withoutValidationConfig().copy$default$4();
        CipherSuites x$22 = this.withoutValidationConfig().copy$default$5();
        Protocols x$23 = this.withoutValidationConfig().copy$default$6();
        boolean x$24 = this.withoutValidationConfig().copy$default$8();
        this.withoutValidation2Config = this.withoutValidationConfig().copy(x$18, x$19, x$20, x$21, x$22, x$23, (ApplicationProtocols)x$17, x$24);
        this.withValidationContext = Netty4ClientSslConfigurations$.MODULE$.createClientContext(this.withValidationConfig(), this.forceJdk());
        this.withoutValidationContext = Netty4ClientSslConfigurations$.MODULE$.createClientContext(this.withoutValidationConfig(), this.forceJdk());
        this.withValidation2Context = Netty4ClientSslConfigurations$.MODULE$.createClientContext(this.withValidation2Config(), false);
        this.withoutValidation2Context = Netty4ClientSslConfigurations$.MODULE$.createClientContext(this.withoutValidation2Config(), false);
    }
}

