/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.codec.compression.zstd;

import com.github.luben.zstd.ZstdDirectBufferDecompressingStream;
import com.twitter.finagle.netty4.codec.compression.MalformedInputException;
import com.twitter.finagle.netty4.codec.compression.zstd.ZstdRefillableDirectBufferDecompressingStream;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class ZstdDecoder
extends ByteToMessageDecoder {
    private static final int ZSTD_MAGIC = -47205080;
    private static final int V_07_ZSTD_MAGIC = -47205081;
    private ZstdDecoderState decompressionState = ZstdDecoderState.CheckMagic;
    private ZstdRefillableDirectBufferDecompressingStream decompressor = null;
    private int decoded = 0;
    private final ByteBuffer inputBuf = ByteBuffer.allocateDirect(131072);
    private final ByteBuffer outputBuf = ByteBuffer.allocateDirect(ZstdDirectBufferDecompressingStream.recommendedTargetBufferSize());

    public ZstdDecoder() {
        this.inputBuf.limit(this.inputBuf.position());
        this.outputBuf.limit(this.outputBuf.capacity());
    }

    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        block9: while (byteBuf.isReadable()) {
            try {
                switch (this.decompressionState) {
                    case CheckMagic: {
                        if (byteBuf.readableBytes() >= 4) {
                            ZstdDecoder.verifyMagic(byteBuf);
                            if (this.decompressor == null) {
                                this.decompressor = new ZstdRefillableDirectBufferDecompressingStream(this.inputBuf);
                            }
                            this.decompressionState = ZstdDecoderState.DecompressData;
                            break;
                        }
                        return;
                    }
                    case DecompressData: {
                        try {
                            this.consumeAndDecompress(channelHandlerContext, byteBuf, list);
                            if (this.decompressor.hasRemaining()) continue block9;
                            this.resetState(true);
                            break;
                        }
                        catch (Exception exception) {
                            this.resetState(false);
                            throw exception;
                        }
                    }
                    case Corrupted: {
                        byteBuf.skipBytes(byteBuf.readableBytes());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (Exception exception) {
                this.decompressionState = ZstdDecoderState.Corrupted;
                throw exception;
            }
        }
    }

    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.resetState(false);
    }

    private void consumeAndDecompress(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws IOException {
        do {
            this.decompressor.transferBuffer(byteBuf);
            this.decoded = this.decompressor.read(this.outputBuf);
            if (this.decoded <= 0) continue;
            this.outputBuf.flip();
            list.add(channelHandlerContext.alloc().buffer(this.decoded, this.decoded).writeBytes(this.outputBuf));
            this.outputBuf.compact();
        } while (this.decoded > 0);
    }

    private void resetState(boolean bl) throws IOException {
        if (this.decompressor != null) {
            this.decompressor.close();
            this.decompressor = null;
        }
        if (bl) {
            this.inputBuf.compact();
            this.inputBuf.limit(this.inputBuf.position());
            this.inputBuf.position(0);
        } else {
            this.inputBuf.clear();
        }
        this.decompressionState = ZstdDecoderState.CheckMagic;
    }

    static void verifyMagic(ByteBuf byteBuf) throws MalformedInputException {
        int n = byteBuf.getIntLE(byteBuf.readerIndex());
        if (n != -47205080) {
            if (n == -47205081) {
                throw new MalformedInputException(byteBuf.readerIndex(), "Data encoded in unsupported ZSTD v0.7 format");
            }
            throw new MalformedInputException(byteBuf.readerIndex(), "Invalid magic prefix: " + Integer.toHexString(n));
        }
    }

    private static enum ZstdDecoderState {
        CheckMagic,
        DecompressData,
        Corrupted;

    }
}

