/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.thrift;

import com.twitter.finagle.Service;
import com.twitter.finagle.SourcedException$;
import com.twitter.finagle.context.Contexts$;
import com.twitter.finagle.service.ReqRep;
import com.twitter.finagle.service.ReqRep$;
import com.twitter.finagle.service.ResponseClass;
import com.twitter.finagle.service.ResponseClassifier$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.thrift.ClientDeserializeCtx;
import com.twitter.finagle.thrift.ClientDeserializeCtx$;
import com.twitter.finagle.thrift.Headers$Request$;
import com.twitter.finagle.thrift.ThriftClientRequest;
import com.twitter.scrooge.TReusableBuffer;
import com.twitter.scrooge.TReusableMemoryTransport;
import com.twitter.scrooge.ThriftStruct;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Throwables$;
import com.twitter.util.Try;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.runtime.BoxedUnit;

public final class ClientFunction$ {
    public static final ClientFunction$ MODULE$ = new ClientFunction$();

    public <T> Future<T> serde(String clientFuncNameForWire, Function1<byte[], Try<T>> replyDeserializer, ThriftStruct inputArgs, String serviceName, Service<ThriftClientRequest, byte[]> service, PartialFunction<ReqRep, ResponseClass> responseClassifier, TReusableBuffer tlReusableBuffer, TProtocolFactory protocolFactory, StatsReceiver failuresScope, Counter requestCounter, Counter successCounter, Counter failuresCounter) {
        requestCounter.incr();
        ClientDeserializeCtx serdeCtx = new ClientDeserializeCtx(inputArgs, replyDeserializer);
        return (Future)Contexts$.MODULE$.local().let(ClientDeserializeCtx$.MODULE$.Key(), serdeCtx, Headers$Request$.MODULE$.Key(), (Object)Headers$Request$.MODULE$.newValues(), (Function0 & Serializable)() -> {
            serdeCtx.rpcName(clientFuncNameForWire);
            long start = System.nanoTime();
            ThriftClientRequest serialized = MODULE$.encodeRequest(clientFuncNameForWire, inputArgs, tlReusableBuffer, protocolFactory);
            serdeCtx.serializationTime(System.nanoTime() - start);
            return service.apply((Object)serialized).flatMap((Function1 & Serializable)response -> Future$.MODULE$.const(serdeCtx.deserialize((byte[])response))).respond((Function1 & Serializable)response -> {
                ClientFunction$.$anonfun$serde$3(responseClassifier, inputArgs, successCounter, failuresCounter, serviceName, failuresScope, response);
                return BoxedUnit.UNIT;
            });
        });
    }

    private ThriftClientRequest encodeRequest(String name, ThriftStruct args, TReusableBuffer tlReusableBuffer, TProtocolFactory protocolFactory) {
        ThriftClientRequest thriftClientRequest;
        TReusableMemoryTransport memoryBuffer = tlReusableBuffer.get();
        try {
            TProtocol oprot = protocolFactory.getProtocol((TTransport)memoryBuffer);
            oprot.writeMessageBegin(new TMessage(name, 1, 0));
            args.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
            byte[] bytes = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
            thriftClientRequest = new ThriftClientRequest(bytes, false);
        }
        finally {
            tlReusableBuffer.reset();
        }
        return thriftClientRequest;
    }

    public static final /* synthetic */ void $anonfun$serde$3(PartialFunction responseClassifier$1, ThriftStruct inputArgs$1, Counter successCounter$1, Counter failuresCounter$1, String serviceName$1, StatsReceiver failuresScope$1, Try response) {
        ResponseClass classified = (ResponseClass)responseClassifier$1.applyOrElse((Object)ReqRep$.MODULE$.apply((Object)inputArgs$1, response), (Function1)ResponseClassifier$.MODULE$.Default());
        ResponseClass responseClass = classified;
        if (responseClass instanceof ResponseClass.Successful) {
            successCounter$1.incr();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (responseClass instanceof ResponseClass.Failed) {
            BoxedUnit boxedUnit;
            failuresCounter$1.incr();
            if (response.isThrow()) {
                SourcedException$.MODULE$.setServiceName(response.throwable(), serviceName$1);
                failuresScope$1.counter(Throwables$.MODULE$.mkString(response.throwable())).incr();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private ClientFunction$() {
    }
}

