/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.thrift;

import com.twitter.finagle.Service;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.thrift.SeqIdFilter$;
import com.twitter.finagle.thrift.SeqMismatchException;
import com.twitter.finagle.thrift.ThriftClientRequest;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Time$;
import com.twitter.util.Try;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005y<Qa\u0004\t\t\u0002e1Qa\u0007\t\t\u0002qAQaI\u0001\u0005\u0002\u0011Bq!J\u0001C\u0002\u0013\u0005a\u0005\u0003\u0004+\u0003\u0001\u0006Ia\n\u0005\bW\u0005\u0011\r\u0011\"\u0001'\u0011\u0019a\u0013\u0001)A\u0005O\u0019!1\u0004\u0005\u0001.\u0011\u0015\u0019s\u0001\"\u0001<\u0011\u0019it\u0001)A\u0005}!1Ai\u0002Q\u0005\n\u0015CaAS\u0004!\n\u0013Y\u0005BB*\bA\u0013%A\u000b\u0003\u0004k\u000f\u0001&Ia\u001b\u0005\u0006e\u001e!\ta]\u0001\f'\u0016\f\u0018\n\u001a$jYR,'O\u0003\u0002\u0012%\u00051A\u000f\u001b:jMRT!a\u0005\u000b\u0002\u000f\u0019Lg.Y4mK*\u0011QCF\u0001\bi^LG\u000f^3s\u0015\u00059\u0012aA2p[\u000e\u0001\u0001C\u0001\u000e\u0002\u001b\u0005\u0001\"aC*fc&#g)\u001b7uKJ\u001c\"!A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011$A\u0006WKJ\u001c\u0018n\u001c8NCN\\W#A\u0014\u0011\u0005yA\u0013BA\u0015 \u0005\rIe\u000e^\u0001\r-\u0016\u00148/[8o\u001b\u0006\u001c8\u000eI\u0001\t-\u0016\u00148/[8oc\u0005Ia+\u001a:tS>t\u0017\u0007I\n\u0003\u000f9\u0002Ba\f\u00193k5\t!#\u0003\u00022%\ta1+[7qY\u00164\u0015\u000e\u001c;feB\u0011!dM\u0005\u0003iA\u00111\u0003\u00165sS\u001a$8\t\\5f]R\u0014V-];fgR\u00042A\b\u001c9\u0013\t9tDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001fs%\u0011!h\b\u0002\u0005\u0005f$X\rF\u0001=!\tQr!A\u0002s]\u001e\u0004\"a\u0010\"\u000e\u0003\u0001S!!Q\u0010\u0002\tU$\u0018\u000e\\\u0005\u0003\u0007\u0002\u0013aAU1oI>l\u0017!B4fiN\u0012DcA\u0014G\u0011\")qI\u0003a\u0001k\u0005\u0019!-\u001e4\t\u000b%S\u0001\u0019A\u0014\u0002\u0007=4g-A\u0003qkR\u001c$\u0007\u0006\u0003M\u001fB\u000b\u0006C\u0001\u0010N\u0013\tquD\u0001\u0003V]&$\b\"B$\f\u0001\u0004)\u0004\"B%\f\u0001\u00049\u0003\"\u0002*\f\u0001\u00049\u0013!\u0001=\u0002\r\t\fG-T:h)\t)V\fE\u0002W1jk\u0011a\u0016\u0006\u0003\u0003RI!!W,\u0003\u000bQC'o\\<\u0011\u0005yY\u0016B\u0001/ \u0005\u001dqu\u000e\u001e5j]\u001eDQA\u0018\u0007A\u0002}\u000b1a\u001e5z!\t\u0001wM\u0004\u0002bKB\u0011!mH\u0007\u0002G*\u0011A\rG\u0001\u0007yI|w\u000e\u001e \n\u0005\u0019|\u0012A\u0002)sK\u0012,g-\u0003\u0002iS\n11\u000b\u001e:j]\u001eT!AZ\u0010\u0002\u0017\u001d,G/\u00118e'\u0016$\u0018\n\u001a\u000b\u0004Y>\u0004\bc\u0001,nO%\u0011an\u0016\u0002\u0004)JL\b\"B$\u000e\u0001\u0004)\u0004\"B9\u000e\u0001\u00049\u0013!\u00028fo&#\u0017!B1qa2LHc\u0001;xsB\u0019a+^\u001b\n\u0005Y<&A\u0002$viV\u0014X\rC\u0003y\u001d\u0001\u0007!'A\u0002sKFDQA\u001f\bA\u0002m\fqa]3sm&\u001cW\r\u0005\u00030yJ*\u0014BA?\u0013\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class SeqIdFilter
extends SimpleFilter<ThriftClientRequest, byte[]> {
    private final Random rng = new Random(Time$.MODULE$.now().inMilliseconds());

    public static int Version1() {
        return SeqIdFilter$.MODULE$.Version1();
    }

    public static int VersionMask() {
        return SeqIdFilter$.MODULE$.VersionMask();
    }

    private int get32(byte[] buf, int off) {
        return (buf[off + 0] & 0xFF) << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
    }

    private void put32(byte[] buf, int off, int x) {
        buf[off] = (byte)(x >> 24 & 0xFF);
        buf[off + 1] = (byte)(x >> 16 & 0xFF);
        buf[off + 2] = (byte)(x >> 8 & 0xFF);
        buf[off + 3] = (byte)(x & 0xFF);
    }

    private Throw<Nothing$> badMsg(String why) {
        return new Throw((Throwable)new IllegalArgumentException(why));
    }

    private Try<Object> getAndSetId(byte[] buf, int newId) {
        int off;
        int n;
        if (buf.length < 4) {
            return this.badMsg("short header");
        }
        int header = this.get32(buf, 0);
        if (header < 0) {
            if ((header & SeqIdFilter$.MODULE$.VersionMask()) != SeqIdFilter$.MODULE$.Version1()) {
                return this.badMsg(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("bad version %d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(header & SeqIdFilter$.MODULE$.VersionMask()))})));
            }
            if (buf.length < 8) {
                return this.badMsg("short name size");
            }
            n = 8 + this.get32(buf, 4);
        } else {
            n = off = 4 + header + 1;
        }
        if (buf.length < off + 4) {
            return this.badMsg("short buffer");
        }
        int currentId = this.get32(buf, off);
        this.put32(buf, off, newId);
        return new Return((Object)BoxesRunTime.boxToInteger((int)currentId));
    }

    public Future<byte[]> apply(ThriftClientRequest req, Service<ThriftClientRequest, byte[]> service) {
        Future future;
        if (req.oneway) {
            future = service.apply((Object)req);
        } else {
            int id;
            int id2;
            byte[] reqBuf = (byte[])req.message.clone();
            Try<Object> try_ = this.getAndSetId(reqBuf, id2 = this.rng.nextInt());
            if (!(try_ instanceof Return)) {
                if (try_ instanceof Throw) {
                    Throw throw_ = (Throw)try_;
                    Throwable exc = throw_.e();
                    return Future$.MODULE$.exception(exc);
                }
                throw new MatchError(try_);
            }
            Return return_ = (Return)try_;
            int n = id = BoxesRunTime.unboxToInt((Object)return_.r());
            int givenId = n;
            ThriftClientRequest newReq = new ThriftClientRequest(reqBuf, req.oneway);
            future = service.apply((Object)newReq).flatMap((Function1 & Serializable)resBuf -> {
                boolean bl = false;
                Return return_ = null;
                Try<Object> try_ = this.getAndSetId((byte[])resBuf, givenId);
                if (try_ instanceof Return) {
                    bl = true;
                    return_ = (Return)try_;
                    int n = BoxesRunTime.unboxToInt((Object)return_.r());
                    if (id2 == n) {
                        return Future$.MODULE$.value(resBuf);
                    }
                }
                if (bl) {
                    int badId = BoxesRunTime.unboxToInt((Object)return_.r());
                    return Future$.MODULE$.exception((Throwable)((Object)new SeqMismatchException(badId, id2)));
                }
                if (!(try_ instanceof Throw)) throw new MatchError(try_);
                Throw throw_ = (Throw)try_;
                Throwable exc = throw_.e();
                return Future$.MODULE$.exception(exc);
            });
        }
        return future;
    }
}

