/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.thrift.exp.partitioning;

import com.twitter.finagle.Address;
import com.twitter.finagle.Service;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.Stack;
import com.twitter.finagle.loadbalancer.LoadBalancerFactory;
import com.twitter.finagle.loadbalancer.distributor.AddrLifecycle$;
import com.twitter.finagle.param.Label;
import com.twitter.finagle.param.Label$;
import com.twitter.finagle.partitioning.PartitionNodeManager;
import com.twitter.finagle.partitioning.PartitioningService;
import com.twitter.finagle.partitioning.SnapPartitioner;
import com.twitter.finagle.thrift.ClientDeserializeCtx$;
import com.twitter.finagle.thrift.ThriftClientRequest;
import com.twitter.finagle.thrift.exp.partitioning.ClientClusterStrategy;
import com.twitter.finagle.thrift.exp.partitioning.ClientCustomStrategy;
import com.twitter.finagle.thrift.exp.partitioning.ClientCustomStrategy$;
import com.twitter.finagle.thrift.exp.partitioning.CustomPartitioningStrategy;
import com.twitter.finagle.thrift.exp.partitioning.MethodBuilderCustomStrategy;
import com.twitter.finagle.thrift.exp.partitioning.ThriftPartitioningService;
import com.twitter.finagle.thrift.exp.partitioning.ThriftPartitioningService$PartitioningStrategyException$;
import com.twitter.finagle.thrift.exp.partitioning.ThriftPartitioningUtil$;
import com.twitter.finagle.thrift.exp.partitioning.ThriftRequestSerializer;
import com.twitter.scrooge.ThriftStructIface;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Time;
import com.twitter.util.Try;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005=f!B\b\u0011\u0001Ya\u0002\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005;\")\u0011\r\u0001C\u0001E\"1\u0001\u000e\u0001Q\u0001\nuCa!\u001b\u0001!\u0002\u0013Q\u0007\u0002CA\f\u0001\u0001\u0006I!!\u0007\t\u0011\u0005}\u0001\u0001)C\u0005\u0003CAq!a\r\u0001\t+\t)\u0004\u0003\u0005\u0002>\u0001!)BFA \u0011\u001d\t)\u0007\u0001C\u000b\u0003OB\u0001\"a \u0001\t\u0003\u0001\u0012\u0011\u0011\u0005\b\u00033\u0003A\u0011IAN\u0005}!\u0006N]5gi\u000e+8\u000f^8n!\u0006\u0014H/\u001b;j_:LgnZ*feZL7-\u001a\u0006\u0003#I\tA\u0002]1si&$\u0018n\u001c8j]\u001eT!a\u0005\u000b\u0002\u0007\u0015D\bO\u0003\u0002\u0016-\u00051A\u000f\u001b:jMRT!a\u0006\r\u0002\u000f\u0019Lg.Y4mK*\u0011\u0011DG\u0001\bi^LG\u000f^3s\u0015\u0005Y\u0012aA2p[V\u0019Q$J\u001a\u0014\u0005\u0001q\u0002\u0003B\u0010\"GIj\u0011\u0001\t\u0006\u0003#YI!A\t\u0011\u0003'A\u000b'\u000f^5uS>t\u0017N\\4TKJ4\u0018nY3\u0011\u0005\u0011*C\u0002\u0001\u0003\u0006M\u0001\u0011\r\u0001\u000b\u0002\u0004%\u0016\f8\u0001A\t\u0003S=\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012qAT8uQ&tw\r\u0005\u0002+a%\u0011\u0011g\u000b\u0002\u0004\u0003:L\bC\u0001\u00134\t\u0015!\u0004A1\u0001)\u0005\r\u0011V\r]\u0001\u000bk:$WM\u001d7zS:<\u0007cA\u001c9u5\ta#\u0003\u0002:-\t)1\u000b^1dWB!qgO\u00123\u0013\tadC\u0001\bTKJ4\u0018nY3GC\u000e$xN]=\u0002%QD'/\u001b4u\u001b\u0006\u00148\u000f[1mY\u0006\u0014G.\u001a\t\u0005\u007fE\u001b#G\u0004\u0002A\u001f:\u0011\u0011I\u0014\b\u0003\u00056s!a\u0011'\u000f\u0005\u0011[eBA#K\u001d\t1\u0015*D\u0001H\u0015\tAu%\u0001\u0004=e>|GOP\u0005\u00027%\u0011\u0011DG\u0005\u0003/aI!!\u0006\f\n\u0005M!\u0012BA\t\u0013\u0013\t\u0001\u0006#A\rUQJLg\r\u001e)beRLG/[8oS:<7+\u001a:wS\u000e,\u0017B\u0001*T\u0005I\u0011V-\u001d*fa6\u000b'o\u001d5bY2\f'\r\\3\u000b\u0005A\u0003\u0012A\u00029be\u0006l7\u000f\u0005\u0002W3:\u0011qgV\u0005\u00031Z\tQa\u0015;bG.L!AW.\u0003\rA\u000b'/Y7t\u0015\tAf#\u0001\nd_:4\u0017nZ;sK\u0012\u001cFO]1uK\u001eL\bC\u00010`\u001b\u0005\u0001\u0012B\u00011\u0011\u0005i\u0019Uo\u001d;p[B\u000b'\u000f^5uS>t\u0017N\\4TiJ\fG/Z4z\u0003\u0019a\u0014N\\5u}Q)1\rZ3gOB!a\fA\u00123\u0011\u0015)T\u00011\u00017\u0011\u0015iT\u00011\u0001?\u0011\u0015!V\u00011\u0001V\u0011\u0015aV\u00011\u0001^\u00039\u0019Wo\u001d;p[N#(/\u0019;fOf\f1B\\8eK6\u000bg.Y4feB\u00121n\u001c\t\u0007?1\u001c#G\\9\n\u00055\u0004#\u0001\u0006)beRLG/[8o\u001d>$W-T1oC\u001e,'\u000f\u0005\u0002%_\u0012I\u0001oBA\u0001\u0002\u0003\u0015\t\u0001\u000b\u0002\u0004?\u0012\n\u0004\u0003\u0002\u0016sijL!a]\u0016\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004\"!\u001e=\u000e\u0003YT!a\u001e\r\u0002\u000fM\u001c'o\\8hK&\u0011\u0011P\u001e\u0002\u0012)\"\u0014\u0018N\u001a;TiJ,8\r^%gC\u000e,\u0007\u0003B>\u007f\u0003\u0003i\u0011\u0001 \u0006\u0003{b\tA!\u001e;jY&\u0011q\u0010 \u0002\u0007\rV$XO]3\u0011\u000f\u0005\r\u0011QBA\ti6\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0005j[6,H/\u00192mK*\u0019\u00111B\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0010\u0005\u0015!aA'baB\u0019!&a\u0005\n\u0007\u0005U1FA\u0002J]R\f!b]3sS\u0006d\u0017N_3s!\rq\u00161D\u0005\u0004\u0003;\u0001\"a\u0006+ie&4GOU3rk\u0016\u001cHoU3sS\u0006d\u0017N_3s\u0003\u001d\u0011\bo\u0019(b[\u0016,\"!a\t\u0011\t\u0005\u0015\u0012Q\u0006\b\u0005\u0003O\tI\u0003\u0005\u0002GW%\u0019\u00111F\u0016\u0002\rA\u0013X\rZ3g\u0013\u0011\ty#!\r\u0003\rM#(/\u001b8h\u0015\r\tYcK\u0001\u001e]>\u0004\u0016M\u001d;ji&|g.\u00138g_Jl\u0017\r^5p]\"\u000bg\u000e\u001a7feR!\u0011qGA\u001d!\rYh0\u000b\u0005\u0007\u0003wQ\u0001\u0019A\u0012\u0002\u0007I,\u0017/\u0001\tqCJ$\u0018\u000e^5p]J+\u0017/^3tiR!\u0011\u0011IA1!\u0011Yh0a\u0011\u0011\u000f\u0005\u0015\u0012QI\u0012\u0002H%!\u0011qBA\u0019!\u0019\tI%a\u0015\u0002Z9!\u00111JA(\u001d\r1\u0015QJ\u0005\u0002Y%\u0019\u0011\u0011K\u0016\u0002\u000fA\f7m[1hK&!\u0011QKA,\u0005\r\u0019V-\u001d\u0006\u0004\u0003#Z\u0003\u0003B>\u007f\u00037\u0002RaNA/GIJ1!a\u0018\u0017\u0005\u001d\u0019VM\u001d<jG\u0016Da!a\u0019\f\u0001\u0004\u0019\u0013\u0001C8sS\u001eLg.\u00197\u0002\u001d5,'oZ3SKN\u0004xN\\:fgR)!'!\u001b\u0002n!1\u00111\u000e\u0007A\u0002\r\n1b\u001c:jO&t\u0017\r\u001c*fc\"9\u0011q\u000e\u0007A\u0002\u0005E\u0014a\u0002:fgVdGo\u001d\t\u0007\u0003g\nIh\t\u001a\u000f\u0007}\t)(C\u0002\u0002x\u0001\n1\u0003U1si&$\u0018n\u001c8j]\u001e\u001cVM\u001d<jG\u0016LA!a\u001f\u0002~\t\u0011\u0002+\u0019:uSRLwN\\3e%\u0016\u001cX\u000f\u001c;t\u0015\r\t9\bI\u0001\u001cO\u0016$\b+\u0019:uSRLwN\\%e\u0003:$'+Z9vKN$X*\u00199\u0015\t\u0005\r\u0015q\u0011\t\u0005wz\f)\tE\u0004\u0002&\u0005\u0015\u0013\u0011\u0003;\t\u000f\u0005%U\u00021\u0001\u0002\f\u0006\u0011\u0001O\u001a\t\u0005\u0003\u001b\u000b\u0019JD\u0002_\u0003\u001fK1!!%\u0011\u0003Q\u0019E.[3oi\u000e+8\u000f^8n'R\u0014\u0018\r^3hs&!\u0011QSAL\u0005A!v\u000eU1si&$\u0018n\u001c8fI6\u000b\u0007OC\u0002\u0002\u0012B\tQa\u00197pg\u0016$B!!(\u0002&B!1P`AP!\rQ\u0013\u0011U\u0005\u0004\u0003G[#\u0001B+oSRDq!a*\u000f\u0001\u0004\tI+\u0001\u0005eK\u0006$G.\u001b8f!\rY\u00181V\u0005\u0004\u0003[c(\u0001\u0002+j[\u0016\u0004")
public class ThriftCustomPartitioningService<Req, Rep>
extends PartitioningService<Req, Rep> {
    private final ThriftPartitioningService.ReqRepMarshallable<Req, Rep> thriftMarshallable;
    private final CustomPartitioningStrategy customStrategy;
    private final PartitionNodeManager<Req, Rep, ?, PartialFunction<ThriftStructIface, Future<Map<Object, ThriftStructIface>>>> nodeManager;
    private final ThriftRequestSerializer serializer;

    private String rpcName() {
        return (String)ClientDeserializeCtx$.MODULE$.get().rpcName().getOrElse((Function0 & Serializable)() -> "N/A");
    }

    public final Future<Nothing$> noPartitionInformationHandler(Req req) {
        ThriftPartitioningService.PartitioningStrategyException ex = new ThriftPartitioningService.PartitioningStrategyException(new StringBuilder(43).append("No Partitioning Ids for the thrift method: ").append(this.rpcName()).toString(), ThriftPartitioningService$PartitioningStrategyException$.MODULE$.$lessinit$greater$default$2(), ThriftPartitioningService$PartitioningStrategyException$.MODULE$.$lessinit$greater$default$3());
        return Future$.MODULE$.exception((Throwable)ex);
    }

    public final Future<Map<Req, scala.collection.immutable.Seq<Future<Service<Req, Rep>>>>> partitionRequest(Req original) {
        SnapPartitioner snapPartitioner = this.nodeManager.snapshotSharder();
        Future<Map<Object, ThriftStructIface>> partitionIdAndRequest = this.getPartitionIdAndRequestMap((PartialFunction<ThriftStructIface, Future<Map<Object, ThriftStructIface>>>)((PartialFunction)snapPartitioner.partitionFunction()));
        return partitionIdAndRequest.flatMap((Function1 & Serializable)idsAndRequests -> {
            Future future;
            if (idsAndRequests.isEmpty()) {
                future = this.noPartitionInformationHandler(original);
            } else if (idsAndRequests.size() == 1) {
                future = Future$.MODULE$.value(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(original), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{snapPartitioner.getServiceByPartitionId(((Tuple2)idsAndRequests.head())._1$mcI$sp())})))})));
            } else {
                scala.collection.mutable.Map reqAndServices = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
                idsAndRequests.foreach((Function1 & Serializable)x0$1 -> {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        int id = tuple2._1$mcI$sp();
                        ThriftStructIface request = (ThriftStructIface)tuple2._2();
                        ThriftClientRequest thriftClientRequest = $this.serializer.serialize(this.rpcName(), request, $this.thriftMarshallable.isOneway(original));
                        Object partitionedReq = $this.thriftMarshallable.framePartitionedRequest(thriftClientRequest, original);
                        if (reqAndServices.contains(partitionedReq)) {
                            reqAndServices.update(partitionedReq, ((SeqOps)reqAndServices.apply(partitionedReq)).$colon$plus((Object)snapPartitioner.getServiceByPartitionId(id)));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = reqAndServices.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partitionedReq), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{snapPartitioner.getServiceByPartitionId(id)}))));
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                });
                future = Future$.MODULE$.value((Object)reqAndServices.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            return future;
        });
    }

    public final Rep mergeResponses(Req originalReq, PartitioningService.PartitionedResults<Req, Rep> results) {
        Function2 merger;
        Object mergerOption;
        Object object;
        CustomPartitioningStrategy customPartitioningStrategy = this.customStrategy;
        if (customPartitioningStrategy instanceof ClientCustomStrategy) {
            ClientCustomStrategy clientCustomStrategy = (ClientCustomStrategy)customPartitioningStrategy;
            object = clientCustomStrategy.responseMergerRegistry().get(this.rpcName());
        } else if (customPartitioningStrategy instanceof MethodBuilderCustomStrategy) {
            MethodBuilderCustomStrategy methodBuilderCustomStrategy = (MethodBuilderCustomStrategy)customPartitioningStrategy;
            object = methodBuilderCustomStrategy.responseMerger();
        } else {
            if (customPartitioningStrategy instanceof ClientClusterStrategy) {
                ClientClusterStrategy clientClusterStrategy = (ClientClusterStrategy)customPartitioningStrategy;
                throw new IllegalStateException(new StringBuilder(125).append(new StringBuilder(39).append("found a ClientClusterStrategy ").append(clientClusterStrategy).append(" after it").toString()).append(" should have been converted to a ClientCustomStrategy.  This state should be ").append("impossible to reach. It indicates a serious bug.").toString());
            }
            throw new MatchError((Object)customPartitioningStrategy);
        }
        Object object2 = mergerOption = object;
        if (!(object2 instanceof Some)) {
            if (None$.MODULE$.equals(object2)) {
                throw new IllegalArgumentException(new StringBuilder(51).append("cannot find the response merger for thrift method: ").append(this.rpcName()).toString());
            }
            throw new MatchError(object2);
        }
        Some some = (Some)object2;
        Function2 function2 = merger = (Function2)some.value();
        Function2 responseMerger = function2;
        Try<Object> mergedResponse = ThriftPartitioningUtil$.MODULE$.mergeResponses(results, (Function2<scala.collection.immutable.Seq<Object>, scala.collection.immutable.Seq<Throwable>, Try<Object>>)responseMerger, (Function1 & Serializable)rep -> $this.thriftMarshallable.fromResponseToBytes(rep));
        ClientDeserializeCtx$.MODULE$.get().mergedDeserializedResponse(mergedResponse);
        return this.thriftMarshallable.emptyResponse();
    }

    public Future<Map<Object, ThriftStructIface>> getPartitionIdAndRequestMap(PartialFunction<ThriftStructIface, Future<Map<Object, ThriftStructIface>>> pf) {
        Future future;
        ThriftStructIface inputArg = (ThriftStructIface)ClientDeserializeCtx$.MODULE$.get().request();
        try {
            Function1 & Serializable getPartitionIdAndRequest = (Function1 & Serializable)ts -> {
                Future future;
                CustomPartitioningStrategy customPartitioningStrategy = $this.customStrategy;
                if (customPartitioningStrategy instanceof ClientCustomStrategy) {
                    future = (Future)pf.applyOrElse(ts, ClientCustomStrategy$.MODULE$.defaultPartitionIdAndRequest());
                } else if (customPartitioningStrategy instanceof MethodBuilderCustomStrategy) {
                    MethodBuilderCustomStrategy methodBuilderCustomStrategy = (MethodBuilderCustomStrategy)customPartitioningStrategy;
                    future = (Future)methodBuilderCustomStrategy.getPartitionIdAndRequest().apply(ts);
                } else {
                    if (customPartitioningStrategy instanceof ClientClusterStrategy) {
                        ClientClusterStrategy clientClusterStrategy = (ClientClusterStrategy)customPartitioningStrategy;
                        throw new IllegalStateException(new StringBuilder(107).append(new StringBuilder(57).append("found a ClientClusterStrategy ").append(clientClusterStrategy).append(" after it should have been ").toString()).append("converted to a ClientCustomStrategy.  This state should be impossible").append(" to reach. It indicates a serious bug.").toString());
                    }
                    throw new MatchError((Object)customPartitioningStrategy);
                }
                return future;
            };
            future = (Future)getPartitionIdAndRequest.apply((Object)inputArg);
        }
        catch (Throwable throwable) {
            Option option;
            Future future2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassCastException) {
                ClassCastException classCastException = (ClassCastException)throwable2;
                future2 = Future$.MODULE$.exception((Throwable)new ThriftPartitioningService.PartitioningStrategyException("MethodBuilder Strategy request type doesn't match with the actual request type, please check the MethodBuilderCustomStrategy type.", classCastException, ThriftPartitioningService$PartitioningStrategyException$.MODULE$.$lessinit$greater$default$3()));
            } else if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                future2 = Future$.MODULE$.exception((Throwable)new ThriftPartitioningService.PartitioningStrategyException(e));
            } else {
                throw throwable;
            }
            future = future2;
        }
        return future;
    }

    public Future<BoxedUnit> close(Time deadline) {
        return Future$.MODULE$.join((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{this.nodeManager.close(deadline), super.close(deadline)})));
    }

    public ThriftCustomPartitioningService(Stack<ServiceFactory<Req, Rep>> underlying, ThriftPartitioningService.ReqRepMarshallable<Req, Rep> thriftMarshallable, Stack.Params params, CustomPartitioningStrategy configuredStrategy) {
        ClientCustomStrategy<Set<Address>> clientCustomStrategy;
        this.thriftMarshallable = thriftMarshallable;
        ClientCustomStrategy<Set<Address>> clientCustomStrategy2 = configuredStrategy;
        if (clientCustomStrategy2 instanceof ClientClusterStrategy) {
            ClientClusterStrategy clientClusterStrategy = (ClientClusterStrategy)((Object)clientCustomStrategy2);
            clientCustomStrategy = new ClientCustomStrategy<Set<Address>>(clientClusterStrategy.getPartitionIdAndRequestFn(), clientClusterStrategy.getLogicalPartitionIdFn(), AddrLifecycle$.MODULE$.varAddrToActivity(((LoadBalancerFactory.Dest)params.apply(LoadBalancerFactory.Dest$.MODULE$.param())).va(), ((Label)params.apply(Label$.MODULE$.param())).label()));
        } else {
            clientCustomStrategy = configuredStrategy;
        }
        this.customStrategy = clientCustomStrategy;
        this.nodeManager = this.customStrategy.newNodeManager(underlying, params);
        this.serializer = new ThriftRequestSerializer(params);
    }
}

