/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.context;

import com.uber.jaeger.context.TraceContext;
import io.opentracing.ActiveSpan;
import io.opentracing.ActiveSpanSource;
import io.opentracing.Span;
import io.opentracing.util.ThreadLocalActiveSpan;
import java.lang.reflect.Field;

public class ActiveSpanSourceTraceContext
implements TraceContext {
    private final ActiveSpanSource activeSpanSource;
    private static final Field wrappedSpan;

    public ActiveSpanSourceTraceContext(ActiveSpanSource activeSpanSource) {
        this.activeSpanSource = activeSpanSource;
    }

    @Override
    public void push(Span span) {
        this.activeSpanSource.makeActive(span);
    }

    @Override
    public Span pop() {
        ActiveSpan activeSpan = this.activeSpanSource.activeSpan();
        Span span = this.getSpan(activeSpan);
        activeSpan.deactivate();
        return span;
    }

    @Override
    public Span getCurrentSpan() {
        ActiveSpan activeSpan = this.activeSpanSource.activeSpan();
        return this.getSpan(activeSpan);
    }

    @Override
    public boolean isEmpty() {
        return this.activeSpanSource.activeSpan() == null;
    }

    private Span getSpan(ActiveSpan activeSpan) {
        Span span;
        try {
            span = (Span)wrappedSpan.get(activeSpan);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return span;
    }

    static {
        try {
            wrappedSpan = ThreadLocalActiveSpan.class.getDeclaredField("wrapped");
            wrappedSpan.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unable to access ThreadLocalActiveSpan.wrapped reflectively.", e);
        }
    }
}

