/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.context;

import com.uber.jaeger.context.ActiveSpanSourceTraceContext;
import com.uber.jaeger.context.TraceContext;
import com.uber.jaeger.context.TracedExecutorService;
import io.opentracing.ActiveSpanSource;
import io.opentracing.util.GlobalTracer;
import java.util.concurrent.ExecutorService;

public class TracingUtils {
    private static TraceContext traceContext = new ActiveSpanSourceTraceContext((ActiveSpanSource)GlobalTracer.get());

    public static TraceContext getTraceContext() {
        TracingUtils.assertGlobalTracerRegistered();
        return traceContext;
    }

    public static ExecutorService tracedExecutor(ExecutorService wrappedExecutorService) {
        TracingUtils.assertGlobalTracerRegistered();
        return new TracedExecutorService(wrappedExecutorService, traceContext);
    }

    private static void assertGlobalTracerRegistered() {
        if (!GlobalTracer.isRegistered()) {
            throw new IllegalStateException("Please register a io.opentracing.util.GlobalTracer.");
        }
    }

    private TracingUtils() {
    }
}

