/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.api;

import com.uber.tchannel.api.TChannel;
import com.uber.tchannel.api.TFuture;
import com.uber.tchannel.api.errors.TChannelConnectionTimeout;
import com.uber.tchannel.api.errors.TChannelError;
import com.uber.tchannel.api.errors.TChannelNoPeerAvailable;
import com.uber.tchannel.api.handlers.HealthCheckRequestHandler;
import com.uber.tchannel.api.handlers.RequestHandler;
import com.uber.tchannel.channels.Connection;
import com.uber.tchannel.channels.PeerManager;
import com.uber.tchannel.channels.SubPeer;
import com.uber.tchannel.errors.ErrorType;
import com.uber.tchannel.handlers.OutRequest;
import com.uber.tchannel.handlers.ResponseRouter;
import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.JSONSerializer;
import com.uber.tchannel.messages.JsonRequest;
import com.uber.tchannel.messages.JsonResponse;
import com.uber.tchannel.messages.RawRequest;
import com.uber.tchannel.messages.RawResponse;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.messages.Response;
import com.uber.tchannel.messages.Serializer;
import com.uber.tchannel.messages.ThriftRequest;
import com.uber.tchannel.messages.ThriftResponse;
import com.uber.tchannel.messages.ThriftSerializer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public final class SubChannel {
    private final String service;
    private final TChannel topChannel;
    private final PeerManager peerManager;
    private final long initTimeout;
    private final Connection.Direction preferredDirection;
    private final List<SubPeer> peers = new ArrayList<SubPeer>();
    private final Map<String, RequestHandler> requestHandlers = new HashMap<String, RequestHandler>();
    private final Serializer serializer = new Serializer((Map<ArgScheme, Serializer.SerializerInterface>)new HashMap<ArgScheme, Serializer.SerializerInterface>(){
        {
            this.put(ArgScheme.JSON, new JSONSerializer());
            this.put(ArgScheme.THRIFT, new ThriftSerializer());
        }
    });
    private final Random random = new Random();

    public SubChannel(String service, TChannel topChannel) {
        this.service = service;
        this.topChannel = topChannel;
        this.peerManager = topChannel.getPeerManager();
        this.initTimeout = topChannel.getInitTimeout();
        this.preferredDirection = Connection.Direction.NONE;
    }

    public SubChannel(String service, TChannel topChannel, Connection.Direction preferredDirection) {
        this.service = service;
        this.topChannel = topChannel;
        this.peerManager = topChannel.getPeerManager();
        this.initTimeout = topChannel.getInitTimeout();
        this.preferredDirection = preferredDirection;
    }

    public String getServiceName() {
        return this.service;
    }

    public PeerManager getPeerManager() {
        return this.peerManager;
    }

    public SubChannel register(String endpoint, RequestHandler requestHandler) {
        this.requestHandlers.put(endpoint, requestHandler);
        return this;
    }

    public SubChannel registerHealthHanlder() {
        return this.registerHealthHandler(new HealthCheckRequestHandler());
    }

    public SubChannel registerHealthHandler(HealthCheckRequestHandler healthHandler) {
        return this.register("Meta::health", healthHandler);
    }

    public RequestHandler getRequestHandler(String endpoint) {
        return this.requestHandlers.get(endpoint);
    }

    public Connection.Direction getPreferredDirection() {
        return this.preferredDirection;
    }

    public SubChannel setPeers(List<InetSocketAddress> peers) {
        for (InetSocketAddress peer : peers) {
            this.peers.add(new SubPeer(peer, this));
        }
        return this;
    }

    public SubPeer choosePeer(OutRequest outRequest) {
        int start;
        SubPeer res = null;
        if (this.peers.size() == 0) {
            return null;
        }
        int i = start = new Random().nextInt(this.peers.size());
        boolean stop = false;
        do {
            SubPeer peer;
            if ((stop = (peer = this.peers.get(i = (i + 1) % this.peers.size())).updateScore(outRequest)) || res == null) {
                res = peer;
                continue;
            }
            if (!(peer.getScore() > res.getScore())) continue;
            res = peer;
        } while (!stop && i != start);
        outRequest.setUsedPeer(res.getRemoteAddress());
        return res;
    }

    public Connection connect(OutRequest outRequest) {
        SubPeer peer = this.choosePeer(outRequest);
        if (peer == null) {
            return null;
        }
        Connection conn = peer.getPreferredConnection();
        if (conn == null) {
            conn = peer.connectTo();
        }
        return conn;
    }

    public boolean sendOutRequest(OutRequest outRequest) {
        boolean res;
        block1: {
            res = false;
            do {
                if (outRequest.shouldRetry()) continue;
                outRequest.setFuture();
                break block1;
            } while (!this.sendOutRequest(outRequest, this.connect(outRequest)));
            res = true;
        }
        return res;
    }

    public <T, U> TFuture<ThriftResponse<U>> send(ThriftRequest<T> request, InetAddress host, int port) throws TChannelError {
        request.setTransportHeader("cn", this.topChannel.getServiceName());
        return this.sendRequest(request, host, port);
    }

    public <T, U> TFuture<ThriftResponse<U>> send(ThriftRequest<T> request) throws TChannelError {
        return this.send(request, null, 0);
    }

    public <T, U> TFuture<JsonResponse<U>> send(JsonRequest<T> request, InetAddress host, int port) {
        request.setTransportHeader("cn", this.topChannel.getServiceName());
        return this.sendRequest(request, host, port);
    }

    public <T, U> TFuture<JsonResponse<U>> send(JsonRequest<T> request) {
        return this.send(request, null, 0);
    }

    public TFuture<RawResponse> send(RawRequest request, InetAddress host, int port) {
        request.setTransportHeader("cn", this.topChannel.getServiceName());
        return this.sendRequest(request, host, port);
    }

    public TFuture<RawResponse> send(RawRequest request) {
        return this.send(request, null, 0);
    }

    protected <V extends Response> TFuture<V> sendRequest(Request request, InetAddress host, int port) {
        OutRequest outRequest = new OutRequest(this, request);
        if (host != null) {
            Connection conn = this.peerManager.findOrNew(new InetSocketAddress(host, port));
            outRequest.disableRetry();
            if (!this.sendOutRequest(outRequest, conn)) {
                outRequest.setFuture();
            }
        } else if (this.peers.size() == 0) {
            outRequest.setLastError(ErrorType.BadRequest, new TChannelNoPeerAvailable());
            outRequest.setFuture();
        } else {
            this.sendOutRequest(outRequest);
        }
        return outRequest.getFuture();
    }

    protected boolean sendOutRequest(OutRequest outRequest, Connection connection) {
        long initTimeout;
        Request request = outRequest.getRequest();
        if (request.getArgScheme() == null) {
            request.setArgScheme(ArgScheme.RAW);
            outRequest.setLastError(ErrorType.BadRequest, "Expect call request to have Arg Scheme specified");
            outRequest.setFuture();
            return false;
        }
        if (request.getRetryFlags() == null) {
            request.setRetryFlags("c");
        }
        if ((initTimeout = this.initTimeout) <= 0L) {
            initTimeout = request.getTimeout();
        }
        if (connection == null) {
            outRequest.setLastError(ErrorType.BadRequest, new TChannelNoPeerAvailable());
            outRequest.setFuture();
            return false;
        }
        if (!connection.waitForIdentified(initTimeout)) {
            connection.clean();
            if (connection.lastError() != null) {
                outRequest.setLastError(ErrorType.NetworkError, connection.lastError());
            } else {
                outRequest.setLastError(ErrorType.NetworkError, new TChannelConnectionTimeout());
            }
            return false;
        }
        ResponseRouter router = connection.channel().pipeline().get(ResponseRouter.class);
        return router.expectResponse(outRequest);
    }
}

