/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.api;

import com.uber.tchannel.api.SubChannel;
import com.uber.tchannel.api.handlers.RequestHandler;
import com.uber.tchannel.channels.ChannelRegistrar;
import com.uber.tchannel.channels.Connection;
import com.uber.tchannel.channels.PeerManager;
import com.uber.tchannel.codecs.TChannelLengthFieldBasedFrameDecoder;
import com.uber.tchannel.handlers.InitRequestHandler;
import com.uber.tchannel.handlers.InitRequestInitiator;
import com.uber.tchannel.handlers.MessageDefragmenter;
import com.uber.tchannel.handlers.MessageFragmenter;
import com.uber.tchannel.handlers.RequestRouter;
import com.uber.tchannel.handlers.ResponseRouter;
import com.uber.tchannel.utils.TChannelUtilities;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.concurrent.Future;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TChannel {
    private static final Logger logger = LoggerFactory.getLogger(TChannel.class);
    private final HashedWheelTimer timer;
    private final String service;
    private final ServerBootstrap serverBootstrap;
    private final PeerManager peerManager;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup childGroup;
    private final InetAddress host;
    private final int port;
    private String listeningHost = "0.0.0.0";
    private int listeningPort;
    private ExecutorService exectorService;
    private final long initTimeout;
    private final int resetOnTimeoutLimit;
    private final int clientMaxPendingRequests;
    private Map<String, SubChannel> subChannels = new HashMap<String, SubChannel>();
    private RequestHandler defaultUserHandler;

    private TChannel(Builder builder) {
        this.service = builder.service;
        this.exectorService = Builder.executorService;
        this.serverBootstrap = builder.serverBootstrap(this);
        this.bossGroup = builder.bossGroup;
        this.childGroup = builder.childGroup;
        this.host = builder.host;
        this.port = builder.port;
        this.initTimeout = builder.initTimeout;
        this.resetOnTimeoutLimit = builder.resetOnTimeoutLimit;
        this.peerManager = new PeerManager(builder.bootstrap(this));
        this.timer = builder.timer;
        this.clientMaxPendingRequests = builder.clientMaxPendingRequests;
    }

    public String getListeningHost() {
        return this.listeningHost;
    }

    public int getListeningPort() {
        return this.listeningPort;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getServiceName() {
        return this.service;
    }

    public PeerManager getPeerManager() {
        return this.peerManager;
    }

    public int getResetOnTimeoutLimit() {
        return this.resetOnTimeoutLimit;
    }

    public long getInitTimeout() {
        return this.initTimeout;
    }

    public boolean isListening() {
        return !this.listeningHost.equals("0.0.0.0");
    }

    public ChannelFuture listen() throws InterruptedException {
        ChannelFuture f = this.serverBootstrap.bind(this.host, this.port).sync();
        InetSocketAddress localAddress = (InetSocketAddress)f.channel().localAddress();
        this.listeningPort = localAddress.getPort();
        this.listeningHost = localAddress.getAddress().getHostAddress();
        this.peerManager.setHostPort(String.format("%s:%d", this.listeningHost, this.listeningPort));
        return f;
    }

    public void setDefaultUserHandler(RequestHandler requestHandler) {
        this.defaultUserHandler = requestHandler;
    }

    public SubChannel getSubChannel(String service) {
        return this.subChannels.get(service);
    }

    public SubChannel makeSubChannel(String service, Connection.Direction preferredDirection) {
        SubChannel subChannel;
        if (this.isListening()) {
            logger.warn("makeSubChannel should be called before listen - service: {}", (Object)service);
        }
        if ((subChannel = this.getSubChannel(service)) == null) {
            subChannel = new SubChannel(service, this, preferredDirection);
            this.subChannels.put(service, subChannel);
        }
        return subChannel;
    }

    public SubChannel makeSubChannel(String service) {
        return this.makeSubChannel(service, Connection.Direction.NONE);
    }

    public void shutdown(boolean sync) {
        this.timer.stop();
        this.peerManager.close();
        Future<?> bg = this.bossGroup.shutdownGracefully();
        Future<?> cg = this.childGroup.shutdownGracefully();
        try {
            if (sync) {
                bg.get();
                cg.get();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            logger.warn("shutdown interrupted.", ie);
        }
        catch (ExecutionException ee) {
            logger.warn("shutdown runs into an ExecutionException.", ee);
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public int getClientMaxPendingRequests() {
        return this.clientMaxPendingRequests;
    }

    public RequestHandler getDefaultUserHandler() {
        return this.defaultUserHandler;
    }

    public static class Builder {
        private final HashedWheelTimer timer;
        private static ExecutorService executorService = new ForkJoinPool();
        private EventLoopGroup bossGroup;
        private EventLoopGroup childGroup;
        private final String service;
        private InetAddress host;
        private int port = 0;
        private long initTimeout = -1L;
        private int resetOnTimeoutLimit = Integer.MAX_VALUE;
        private int clientMaxPendingRequests = 100000;

        public Builder(String service) {
            if (service == null) {
                throw new NullPointerException("`service` cannot be null");
            }
            this.service = service;
            this.host = TChannelUtilities.getCurrentIp();
            if (this.host == null) {
                logger.error("failed to get current IP");
            }
            this.timer = new HashedWheelTimer(10L, TimeUnit.MILLISECONDS);
            this.bossGroup = new NioEventLoopGroup(1);
            this.childGroup = new NioEventLoopGroup();
        }

        public Builder setExecutorService(ExecutorService executorService) {
            Builder.executorService = executorService;
            return this;
        }

        public Builder setClientMaxPendingRequests(int clientMaxPendingRequests) {
            this.clientMaxPendingRequests = clientMaxPendingRequests;
            return this;
        }

        public Builder setServerHost(InetAddress host) {
            this.host = host;
            return this;
        }

        public Builder setServerPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setBossGroup(EventLoopGroup bossGroup) {
            this.bossGroup = bossGroup;
            return this;
        }

        public Builder setChildGroup(EventLoopGroup childGroup) {
            this.childGroup = childGroup;
            return this;
        }

        public Builder setInitTimeout(long initTimeout) {
            this.initTimeout = initTimeout;
            return this;
        }

        public Builder setResetOnTimeoutLimit(int resetOnTimeoutLimit) {
            this.resetOnTimeoutLimit = resetOnTimeoutLimit;
            return this;
        }

        public TChannel build() {
            return new TChannel(this);
        }

        private Bootstrap bootstrap(TChannel topChannel) {
            return ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.childGroup)).channel(NioSocketChannel.class)).handler(this.channelInitializer(false, topChannel))).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, 32768)).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, 8192)).validate();
        }

        private ServerBootstrap serverBootstrap(TChannel topChannel) {
            return ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.childGroup).channel(NioServerSocketChannel.class)).handler(new LoggingHandler(LogLevel.INFO))).option(ChannelOption.SO_BACKLOG, 128)).childHandler(this.channelInitializer(true, topChannel)).childOption(ChannelOption.SO_KEEPALIVE, true).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, 32768).childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, 8192).validate();
        }

        private ChannelInitializer<SocketChannel> channelInitializer(final boolean isServer, final TChannel topChannel) {
            return new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast("FrameDecoder", (ChannelHandler)new TChannelLengthFieldBasedFrameDecoder());
                    if (isServer) {
                        ch.pipeline().addLast("InitRequestHandler", (ChannelHandler)new InitRequestHandler(topChannel.getPeerManager()));
                    } else {
                        ch.pipeline().addLast("InitRequestInitiator", (ChannelHandler)new InitRequestInitiator(topChannel.getPeerManager()));
                    }
                    ch.pipeline().addLast("MessageDefragmenter", (ChannelHandler)new MessageDefragmenter());
                    ch.pipeline().addLast("MessageFragmenter", (ChannelHandler)new MessageFragmenter());
                    ch.pipeline().addLast("RequestRouter", (ChannelHandler)new RequestRouter(topChannel, executorService));
                    ch.pipeline().addLast("ResponseRouter", (ChannelHandler)new ResponseRouter(topChannel, Builder.this.timer));
                    ch.pipeline().addLast("ChannelRegistrar", (ChannelHandler)new ChannelRegistrar(topChannel.getPeerManager()));
                }
            };
        }
    }
}

