/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.channels;

import com.uber.tchannel.channels.PeerManager;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelRegistrar
extends ChannelHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ChannelRegistrar.class);
    private final PeerManager peerManager;

    public ChannelRegistrar(PeerManager peerManager) {
        this.peerManager = peerManager;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.peerManager.add(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.peerManager.remove(ctx.channel());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("Exception detected, reseting connection.", cause);
        this.peerManager.handleConnectionErrors(ctx.channel(), cause);
    }
}

