/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.channels;

import com.uber.tchannel.api.errors.TChannelError;
import com.uber.tchannel.channels.ConnectionState;
import com.uber.tchannel.channels.Peer;
import com.uber.tchannel.handlers.ResponseRouter;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    public Direction direction = Direction.NONE;
    public ConnectionState state = ConnectionState.UNCONNECTED;
    private Peer peer;
    private final Channel channel;
    private String remoteAddress = null;
    private TChannelError lastError = null;

    public Connection(Peer peer, Channel channel, Direction direction) {
        this.peer = peer;
        this.channel = channel;
        this.direction = direction;
        if (channel.isActive() && this.state == ConnectionState.UNCONNECTED) {
            this.state = ConnectionState.CONNECTED;
        }
    }

    public Channel channel() {
        return this.channel;
    }

    public TChannelError lastError() {
        return this.lastError;
    }

    public synchronized boolean satisfy(ConnectionState preferedState) {
        ConnectionState connState = this.state;
        if (connState == ConnectionState.DESTROYED) {
            return false;
        }
        if (preferedState == null) {
            return true;
        }
        if (connState == preferedState || connState == ConnectionState.IDENTIFIED) {
            return true;
        }
        return connState == ConnectionState.CONNECTED && preferedState == ConnectionState.UNCONNECTED;
    }

    public synchronized boolean satisfy(Direction preferedDirection) {
        Direction dir = this.direction;
        if (preferedDirection == null || preferedDirection == Direction.NONE) {
            return true;
        }
        return preferedDirection == dir;
    }

    public synchronized void setState(ConnectionState state) {
        this.state = state;
        if (state == ConnectionState.IDENTIFIED || state == ConnectionState.UNCONNECTED && this.lastError != null) {
            this.notifyAll();
        }
    }

    public synchronized void setIndentified(Map<String, String> headers) {
        String hostPort = headers.get("host_port");
        if (hostPort == null) {
            hostPort = "0.0.0.0:0";
        }
        this.remoteAddress = hostPort.trim();
        this.setState(ConnectionState.IDENTIFIED);
    }

    public synchronized void setIndentified(TChannelError error) {
        this.remoteAddress = null;
        this.lastError = error;
        this.setState(ConnectionState.UNCONNECTED);
    }

    public boolean isIndentified() {
        return this.state == ConnectionState.IDENTIFIED;
    }

    public synchronized boolean isEphemeral() {
        return this.remoteAddress.equals("0.0.0.0:0");
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getRemoteAddressAsSocketAddress() {
        return Connection.hostPortToSocketAddress(this.remoteAddress);
    }

    public static String[] splitHostPort(String hostPort) {
        String[] strs = hostPort.split(":");
        if (strs.length != 2) {
            strs = new String[]{"0.0.0.0:", "0"};
        }
        return strs;
    }

    public static SocketAddress hostPortToSocketAddress(String hostPort) {
        String[] strs = Connection.splitHostPort(hostPort);
        return new InetSocketAddress(strs[0], Integer.parseInt(strs[1]));
    }

    public synchronized boolean waitForIdentified(long timeout) {
        boolean result;
        try {
            if (this.state != ConnectionState.IDENTIFIED) {
                this.lastError = null;
                this.wait(timeout);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            logger.warn("wait for identified is interrupted.", ex);
        }
        boolean bl = result = this.state == ConnectionState.IDENTIFIED;
        if (!result) {
            this.clean();
        }
        return result;
    }

    public synchronized void close() {
        ResponseRouter responseRouter = this.channel.pipeline().get(ResponseRouter.class);
        if (responseRouter != null) {
            responseRouter.clean();
        }
        this.channel.close();
        this.state = ConnectionState.DESTROYED;
    }

    public void clean() {
        this.close();
        this.peer.remove(this);
    }

    public Peer getPeer() {
        return this.peer;
    }

    public void setPeer(Peer peer) {
        this.peer = peer;
    }

    public static enum Direction {
        NONE,
        IN,
        OUT;

    }
}

