/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.channels;

import com.uber.tchannel.channels.Connection;

public enum ConnectionState {
    UNCONNECTED("unconnected"),
    CONNECTED("connected"),
    IDENTIFIED("identified"),
    DESTROYED("destroyed");

    private final String state;

    private ConnectionState(String state) {
        this.state = state;
    }

    public static ConnectionState toState(String state) {
        if (state == null) {
            return null;
        }
        switch (state) {
            case "unconnected": {
                return UNCONNECTED;
            }
            case "connected": {
                return CONNECTED;
            }
            case "identified": {
                return IDENTIFIED;
            }
            case "destroyed": {
                return DESTROYED;
            }
        }
        return null;
    }

    public static boolean isConnected(ConnectionState state) {
        ConnectionState s = state;
        return s == IDENTIFIED || s == CONNECTED;
    }

    public static boolean isConnected(Connection conn) {
        if (conn == null) {
            return false;
        }
        return ConnectionState.isConnected(conn.state);
    }

    public String getState() {
        return this.state;
    }
}

