/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.channels;

import com.uber.tchannel.api.errors.TChannelConnectionFailure;
import com.uber.tchannel.channels.Connection;
import com.uber.tchannel.channels.ConnectionState;
import com.uber.tchannel.channels.PeerManager;
import com.uber.tchannel.codecs.MessageCodec;
import com.uber.tchannel.frames.InitRequestFrame;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Peer {
    public ConcurrentHashMap<ChannelId, Connection> connections = new ConcurrentHashMap();
    public SocketAddress remoteAddress = null;
    private PeerManager manager;

    public Peer(PeerManager manager, SocketAddress remoteAddress) {
        this.manager = manager;
        this.remoteAddress = remoteAddress;
    }

    public Connection add(Connection connection) {
        Connection conn = this.connections.putIfAbsent(connection.channel().id(), connection);
        if (conn != null) {
            return conn;
        }
        return connection;
    }

    public Connection add(Channel channel, Connection.Direction direction) {
        Connection conn = this.connections.get(channel.id());
        if (conn != null) {
            return conn;
        }
        return this.add(new Connection(this, channel, direction));
    }

    public Connection handleActiveOutConnection(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        Connection conn = this.add(channel, Connection.Direction.OUT);
        InitRequestFrame initRequestFrame = new InitRequestFrame(0L, 2, (Map<String, String>)new HashMap<String, String>(){});
        initRequestFrame.setHostPort(this.manager.getHostPort());
        initRequestFrame.setProcessName("java-process");
        MessageCodec.write(ctx, initRequestFrame);
        return conn;
    }

    public void remove(Connection connection) {
        this.connections.remove(connection.channel().id());
    }

    public Connection remove(Channel channel) {
        Connection conn = this.connections.remove(channel.id());
        return conn;
    }

    public Connection connect(Bootstrap bootstrap, Connection.Direction preferredDirection) {
        Connection conn = this.getConnection(ConnectionState.IDENTIFIED, preferredDirection);
        if (conn != null && (conn.satisfy(preferredDirection) || preferredDirection == Connection.Direction.IN)) {
            return conn;
        }
        ChannelFuture f = bootstrap.connect(this.remoteAddress);
        Channel channel = f.channel();
        final Connection connection = this.add(channel, Connection.Direction.OUT);
        f.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    connection.setIndentified(new TChannelConnectionFailure(future.cause()));
                }
            }
        });
        return connection;
    }

    public Connection connect(Bootstrap bootstrap) {
        return this.connect(bootstrap, Connection.Direction.NONE);
    }

    public Connection getConnection(ConnectionState preferedState, Connection.Direction preferredDirection) {
        Connection conn = null;
        Connection next = null;
        for (ChannelId id : this.connections.keySet()) {
            next = this.connections.get(id);
            if (next.satisfy(preferedState)) {
                conn = next;
                if (preferredDirection != Connection.Direction.NONE && conn.direction != preferredDirection) continue;
                break;
            }
            if (conn != null) continue;
            conn = next;
        }
        return conn;
    }

    public Connection getConnection(ConnectionState preferedState) {
        return this.getConnection(preferedState, Connection.Direction.NONE);
    }

    public Connection getConnection(ChannelId channelId) {
        return this.connections.get(channelId);
    }

    public void close() {
        for (ChannelId id : this.connections.keySet()) {
            Connection conn = this.connections.get(id);
            if (conn == null) continue;
            conn.close();
        }
        this.connections.clear();
    }

    public Map<String, Integer> getStats() {
        int in = 0;
        int out = 0;
        for (ChannelId id : this.connections.keySet()) {
            Connection conn = this.connections.get(id);
            if (conn == null) continue;
            if (conn.direction == Connection.Direction.OUT) {
                ++out;
                continue;
            }
            ++in;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("connections.in", in);
        result.put("connections.out", out);
        return result;
    }
}

