/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.channels;

import com.uber.tchannel.channels.Connection;
import com.uber.tchannel.channels.Peer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerManager {
    private static final Logger logger = LoggerFactory.getLogger(PeerManager.class);
    private final Bootstrap clientBootstrap;
    private final ConcurrentHashMap<SocketAddress, Peer> peers = new ConcurrentHashMap();
    private final ConcurrentHashMap<ChannelId, SocketAddress> channelTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<ChannelId, Connection> inConnections = new ConcurrentHashMap();
    private String hostPort = "0.0.0.0:0";

    public PeerManager(Bootstrap clientBootstrap) {
        this.clientBootstrap = clientBootstrap;
    }

    public Connection findOrNew(SocketAddress address) {
        Peer peer = this.peers.get(address);
        if (peer == null) {
            peer = new Peer(this, address);
            this.peers.putIfAbsent(address, peer);
            peer = this.peers.get(address);
        }
        return peer.connect(this.clientBootstrap);
    }

    public Peer findOrNewPeer(SocketAddress address) {
        Peer peer = this.peers.get(address);
        if (peer == null) {
            peer = new Peer(this, address);
            this.peers.putIfAbsent(address, peer);
            peer = this.peers.get(address);
        }
        return peer;
    }

    public Peer getPeer(SocketAddress address) {
        return this.peers.get(address);
    }

    public Peer getPeer(Channel channel) {
        SocketAddress address = channel.remoteAddress();
        return this.peers.get(address);
    }

    public Connection connectTo(SocketAddress address) {
        Peer peer = this.findOrNewPeer(address);
        return peer.connect(this.clientBootstrap, Connection.Direction.OUT);
    }

    public Connection get(Channel channel) {
        SocketAddress address = channel.remoteAddress();
        Peer peer = this.peers.get(address);
        if (peer != null) {
            return peer.getConnection(channel.id());
        }
        return null;
    }

    public void add(ChannelHandlerContext ctx) {
        Connection.Direction direction = Connection.Direction.OUT;
        if (ctx.pipeline().names().contains("InitRequestHandler")) {
            direction = Connection.Direction.IN;
        }
        if (direction == Connection.Direction.IN) {
            return;
        }
        Channel channel = ctx.channel();
        SocketAddress address = channel.remoteAddress();
        Peer peer = this.findOrNewPeer(address);
        peer.handleActiveOutConnection(ctx);
    }

    public Connection remove(Channel channel) {
        SocketAddress address = channel.remoteAddress();
        Peer peer = this.peers.get(address);
        if (peer != null) {
            return peer.remove(channel);
        }
        address = this.channelTable.remove(channel.id());
        if (address == null) {
            return null;
        }
        peer = this.peers.get(address);
        if (peer != null) {
            return peer.remove(channel);
        }
        return null;
    }

    public void setIdentified(Channel channel, Map<String, String> headers) {
        Connection conn = this.get(channel);
        if (conn == null) {
            conn = new Connection(null, channel, Connection.Direction.IN);
        }
        conn.setIndentified(headers);
        if (!conn.isEphemeral() && conn.direction == Connection.Direction.IN) {
            SocketAddress address = conn.getRemoteAddressAsSocketAddress();
            this.channelTable.put(channel.id(), address);
            Peer peer = this.findOrNewPeer(address);
            conn.setPeer(peer);
            peer.add(conn);
        }
    }

    public void handleConnectionErrors(Channel channel, Throwable cause) {
        logger.error("Resetting connection due to the error.", cause);
        Connection conn = this.remove(channel);
        if (conn != null) {
            conn.clean();
        }
    }

    public void close() {
        for (SocketAddress addr : this.peers.keySet()) {
            this.peers.get(addr).close();
        }
        this.peers.clear();
    }

    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public Map<String, Integer> getStats() {
        int in = 0;
        int out = 0;
        for (SocketAddress addr : this.peers.keySet()) {
            Map<String, Integer> connStats = this.peers.get(addr).getStats();
            in += connStats.get("connections.in").intValue();
            out += connStats.get("connections.out").intValue();
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("connections.in", in);
        result.put("connections.out", out);
        return result;
    }
}

