/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.checksum;

public enum ChecksumType {
    NoChecksum(0),
    Adler32(1),
    FarmhashFingerPrint32(2),
    CRC32C(3);

    private final byte type;

    private ChecksumType(byte type) {
        this.type = type;
    }

    public static ChecksumType fromByte(byte value) {
        switch (value) {
            case 0: {
                return NoChecksum;
            }
            case 1: {
                return Adler32;
            }
            case 2: {
                return FarmhashFingerPrint32;
            }
            case 3: {
                return CRC32C;
            }
        }
        return null;
    }

    public byte byteValue() {
        return this.type;
    }
}

