/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.codecs;

import com.uber.tchannel.checksum.ChecksumType;
import com.uber.tchannel.tracing.Trace;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CodecUtils {
    public static int decodeChecksum(ChecksumType checksumType, ByteBuf buffer) {
        switch (checksumType) {
            case Adler32: 
            case FarmhashFingerPrint32: 
            case CRC32C: {
                return buffer.readInt();
            }
        }
        return 0;
    }

    public static void encodeChecksum(int checksum, ChecksumType checksumType, ByteBuf buffer) {
        switch (checksumType) {
            case Adler32: 
            case FarmhashFingerPrint32: 
            case CRC32C: {
                buffer.writeInt(checksum);
                break;
            }
        }
    }

    public static String decodeString(ByteBuf buffer) {
        int valueLength = buffer.readUnsignedShort();
        byte[] valueBytes = new byte[valueLength];
        buffer.readBytes(valueBytes);
        return new String(valueBytes);
    }

    public static void encodeString(String value, ByteBuf buffer) {
        byte[] raw = value.getBytes();
        buffer.writeShort(raw.length);
        buffer.writeBytes(raw);
    }

    public static String decodeSmallString(ByteBuf buffer) {
        short valueLength = buffer.readUnsignedByte();
        byte[] valueBytes = new byte[valueLength];
        buffer.readBytes(valueBytes);
        return new String(valueBytes);
    }

    public static void encodeSmallString(String value, ByteBuf buffer) {
        byte[] raw = value.getBytes();
        buffer.writeByte(raw.length);
        buffer.writeBytes(raw);
    }

    public static Map<String, String> decodeHeaders(ByteBuf buffer) {
        int numHeaders = buffer.readUnsignedShort();
        HashMap<String, String> headers = new HashMap<String, String>(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            String key = CodecUtils.decodeString(buffer);
            String value = CodecUtils.decodeString(buffer);
            headers.put(key, value);
        }
        return headers;
    }

    public static void encodeHeaders(Map<String, String> headers, ByteBuf buffer) {
        buffer.writeShort(headers.size());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            CodecUtils.encodeString(header.getKey(), buffer);
            CodecUtils.encodeString(header.getValue(), buffer);
        }
    }

    public static Map<String, String> decodeSmallHeaders(ByteBuf buffer) {
        int numHeaders = buffer.readUnsignedByte();
        HashMap<String, String> headers = new HashMap<String, String>(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            String key = CodecUtils.decodeSmallString(buffer);
            String value = CodecUtils.decodeSmallString(buffer);
            headers.put(key, value);
        }
        return headers;
    }

    public static void encodeSmallHeaders(Map<String, String> headers, ByteBuf buffer) {
        buffer.writeByte(headers.size());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            CodecUtils.encodeSmallString(header.getKey(), buffer);
            CodecUtils.encodeSmallString(header.getValue(), buffer);
        }
    }

    public static Trace decodeTrace(ByteBuf buffer) {
        long spanId = buffer.readLong();
        long parentId = buffer.readLong();
        long traceId = buffer.readLong();
        byte traceFlags = buffer.readByte();
        return new Trace(spanId, parentId, traceId, traceFlags);
    }

    public static void encodeTrace(Trace trace, ByteBuf buffer) {
        buffer.writeLong(trace.spanId).writeLong(trace.parentId).writeLong(trace.traceId).writeByte(trace.traceFlags);
    }

    public static int writeArg(ByteBufAllocator allocator, ByteBuf arg, int writableBytes, List<ByteBuf> bufs) {
        if (writableBytes <= 2) {
            throw new UnsupportedOperationException("writableBytes must be larger than 2");
        }
        int readableBytes = arg.readableBytes();
        int headerSize = 2;
        int chunkLength = Math.min(readableBytes + headerSize, writableBytes);
        ByteBuf sizeBuf = allocator.buffer(2);
        bufs.add(sizeBuf);
        sizeBuf.writeShort(chunkLength - headerSize);
        if (readableBytes == 0) {
            return 2;
        }
        bufs.add(arg.readSlice(chunkLength - headerSize).retain());
        return chunkLength;
    }

    public static ByteBuf writeArgs(ByteBufAllocator allocator, ByteBuf header, List<ByteBuf> args) {
        ByteBuf arg;
        int len;
        int writableBytes = 65519 - header.readableBytes();
        ArrayList<ByteBuf> bufs = new ArrayList<ByteBuf>(7);
        bufs.add(header);
        while (!args.isEmpty() && (writableBytes -= (len = CodecUtils.writeArg(allocator, arg = args.get(0), writableBytes, bufs))) > 2) {
            if (arg.readableBytes() != 0) continue;
            args.remove(0);
        }
        CompositeByteBuf comp = allocator.compositeBuffer();
        comp.addComponents(bufs);
        comp.writerIndex(65519 - writableBytes);
        return comp;
    }

    public static ByteBuf writeArgCopy(ByteBufAllocator allocator, ByteBuf payload, ByteBuf arg, int writableBytes) {
        if (writableBytes <= 2) {
            throw new UnsupportedOperationException("writableBytes must be larger than 2");
        }
        int readableBytes = arg.readableBytes();
        int headerSize = 2;
        int chunkLength = Math.min(readableBytes + headerSize, writableBytes);
        payload.writeShort(chunkLength - headerSize);
        if (readableBytes == 0) {
            return payload;
        }
        return payload.writeBytes(arg, chunkLength - headerSize);
    }

    public static ByteBuf writeArgsCopy(ByteBufAllocator allocator, ByteBuf header, List<ByteBuf> args) {
        ByteBuf payload = allocator.buffer(header.readableBytes(), 65519);
        payload.writeBytes(header);
        header.release();
        int writableBytes = 65519 - payload.readableBytes();
        while (!args.isEmpty()) {
            ByteBuf arg = args.get(0);
            CodecUtils.writeArgCopy(allocator, payload, arg, writableBytes);
            writableBytes = 65519 - payload.readableBytes();
            if (writableBytes <= 2) break;
            if (arg.readableBytes() != 0) continue;
            args.remove(0);
        }
        return payload;
    }

    public static ByteBuf compose(ByteBuf first, ByteBuf second) {
        if (first == Unpooled.EMPTY_BUFFER) {
            return second;
        }
        if (second == Unpooled.EMPTY_BUFFER) {
            return first;
        }
        return Unpooled.wrappedBuffer(first, second);
    }

    public static ByteBuf readArg(ByteBuf buffer) {
        if (buffer.readableBytes() < 2) {
            return null;
        }
        int len = buffer.readUnsignedShort();
        if (len > buffer.readableBytes()) {
            throw new UnsupportedOperationException("wrong read index for args");
        }
        if (len == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf arg = buffer.readSlice(len);
        arg.retain();
        return arg;
    }

    public static void readArgs(List<ByteBuf> args, ByteBuf buffer) {
        ByteBuf arg = null;
        if (args.isEmpty()) {
            args.add(Unpooled.EMPTY_BUFFER);
        }
        boolean first = true;
        while ((arg = CodecUtils.readArg(buffer)) != null) {
            if (first) {
                first = false;
                ByteBuf prev = args.get(args.size() - 1);
                args.set(args.size() - 1, CodecUtils.compose(prev, arg));
                continue;
            }
            args.add(arg);
        }
        return;
    }
}

