/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.codecs;

import com.uber.tchannel.frames.FrameType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;

public class TFrame
implements ByteBufHolder {
    public static final int MAX_FRAME_LENGTH = 65535;
    public static final int FRAME_HEADER_LENGTH = 16;
    public static final int FRAME_SIZE_LENGTH = 2;
    public static final int MAX_FRAME_PAYLOAD_LENGTH = 65519;
    public static final int LENGTH_FIELD_OFFSET = 0;
    public static final int LENGTH_FIELD_LENGTH = 2;
    public static final int LENGTH_ADJUSTMENT = -2;
    public static final int INITIAL_BYTES_TO_STRIP = 0;
    public static final boolean FAIL_FAST = true;
    public final int size;
    public final byte type;
    public final long id;
    public final ByteBuf payload;

    public TFrame(int size, byte type, long id, ByteBuf payload) {
        this.size = size;
        this.type = type;
        this.id = id;
        this.payload = payload;
    }

    public TFrame(int size, FrameType frameType, long id, ByteBuf payload) {
        this(size, frameType.byteValue(), id, payload);
    }

    public String toString() {
        return String.format("<%s size=%d type=0x%d id=%d payload=%s>", this.getClass().getSimpleName(), this.size, this.type, this.id, this.payload);
    }

    @Override
    public ByteBuf content() {
        return this.payload;
    }

    @Override
    public ByteBufHolder copy() {
        return new TFrame(this.size, this.type, this.id, this.payload.copy());
    }

    @Override
    public ByteBufHolder duplicate() {
        return new TFrame(this.size, this.type, this.id, this.payload.duplicate());
    }

    @Override
    public ByteBufHolder retain() {
        this.payload.retain();
        return this;
    }

    @Override
    public ByteBufHolder retain(int i) {
        this.payload.retain(i);
        return this;
    }

    @Override
    public ByteBufHolder touch() {
        this.payload.touch();
        return this;
    }

    @Override
    public ByteBufHolder touch(Object o) {
        this.payload.touch(o);
        return this;
    }

    @Override
    public int refCnt() {
        return this.payload.refCnt();
    }

    @Override
    public boolean release() {
        return this.payload.release();
    }

    @Override
    public boolean release(int i) {
        return this.payload.release(i);
    }
}

