/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.frames;

import com.uber.tchannel.checksum.ChecksumType;
import com.uber.tchannel.codecs.CodecUtils;
import com.uber.tchannel.frames.Frame;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;

public abstract class CallFrame
extends Frame
implements ByteBufHolder {
    public static final byte MORE_FRAGMENTS_REMAIN_MASK = 1;
    public static final short MAX_ARG1_LENGTH = 16384;
    protected byte flags = 0;
    protected ByteBuf payload = null;
    protected ChecksumType checksumType = ChecksumType.NoChecksum;
    protected int checksum = 0;

    public final byte getFlags() {
        return this.flags;
    }

    public boolean moreFragmentsFollow() {
        return (this.flags & 1) == 1;
    }

    public ChecksumType getChecksumType() {
        return this.checksumType;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public final ByteBuf getPayload() {
        return this.payload;
    }

    public final void setPayload(ByteBuf payload) {
        this.payload = payload;
    }

    public final int getPayloadSize() {
        return this.payload.writerIndex() - this.payload.readerIndex();
    }

    public final boolean isPayloadFull() {
        return this.getPayloadSize() + 2 >= 65519;
    }

    public final ByteBuf encodePayload(ByteBufAllocator allocator) {
        ArrayList<ByteBuf> args = new ArrayList<ByteBuf>();
        args.add(Unpooled.EMPTY_BUFFER);
        args.add(Unpooled.EMPTY_BUFFER);
        args.add(Unpooled.EMPTY_BUFFER);
        return this.encodePayload(allocator, args);
    }

    public final ByteBuf encodePayload(ByteBufAllocator allocator, List<ByteBuf> args) {
        ByteBuf payload = CodecUtils.writeArgs(allocator, this.encodeHeader(allocator), args);
        if (args.isEmpty()) {
            this.flags = 0;
            payload.setByte(0, 0);
        } else {
            this.flags = 1;
            payload.setByte(0, 1);
        }
        this.payload = payload;
        return payload;
    }

    @Override
    public ByteBuf content() {
        return this.payload;
    }

    @Override
    public ByteBufHolder retain() {
        this.payload.retain();
        return this;
    }

    @Override
    public ByteBufHolder retain(int i) {
        this.payload.retain(i);
        return this;
    }

    @Override
    public ByteBufHolder touch() {
        this.payload.touch();
        return this;
    }

    @Override
    public ByteBufHolder touch(Object o) {
        this.payload.touch(o);
        return this;
    }

    @Override
    public int refCnt() {
        return this.payload.refCnt();
    }

    @Override
    public boolean release() {
        return this.payload.release();
    }

    @Override
    public boolean release(int i) {
        return this.payload.release(i);
    }
}

