/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.frames;

import com.uber.tchannel.checksum.ChecksumType;
import com.uber.tchannel.codecs.CodecUtils;
import com.uber.tchannel.codecs.TFrame;
import com.uber.tchannel.frames.CallFrame;
import com.uber.tchannel.frames.FrameType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;

public final class CallRequestContinueFrame
extends CallFrame {
    public CallRequestContinueFrame(long id, byte flags, ChecksumType checksumType, int checksum, ByteBuf payload) {
        this.id = id;
        this.flags = flags;
        this.checksumType = checksumType;
        this.checksum = checksum;
        this.payload = payload;
    }

    protected CallRequestContinueFrame(long id) {
        this.id = id;
    }

    @Override
    public FrameType getType() {
        return FrameType.CallRequestContinue;
    }

    @Override
    public ByteBufHolder copy() {
        return new CallRequestContinueFrame(this.id, this.flags, this.checksumType, this.checksum, this.payload.copy());
    }

    @Override
    public ByteBufHolder duplicate() {
        return new CallRequestContinueFrame(this.id, this.flags, this.checksumType, this.checksum, this.payload.duplicate());
    }

    @Override
    public ByteBuf encodeHeader(ByteBufAllocator allocator) {
        ByteBuf buffer = allocator.buffer(2, 6);
        buffer.writeByte(this.getFlags());
        buffer.writeByte(this.getChecksumType().byteValue());
        CodecUtils.encodeChecksum(this.getChecksum(), this.getChecksumType(), buffer);
        return buffer;
    }

    @Override
    public void decode(TFrame tFrame) {
        this.flags = tFrame.payload.readByte();
        this.checksumType = ChecksumType.fromByte(tFrame.payload.readByte());
        this.checksum = CodecUtils.decodeChecksum(this.checksumType, tFrame.payload);
        int payloadSize = tFrame.size - tFrame.payload.readerIndex();
        this.payload = tFrame.payload.readSlice(payloadSize);
    }
}

