/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.frames;

import com.uber.tchannel.api.ResponseCode;
import com.uber.tchannel.checksum.ChecksumType;
import com.uber.tchannel.codecs.CodecUtils;
import com.uber.tchannel.codecs.TFrame;
import com.uber.tchannel.frames.CallFrame;
import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.tracing.Trace;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import java.util.Map;

public final class CallResponseFrame
extends CallFrame {
    private ResponseCode responseCode;
    private Trace tracing;
    private Map<String, String> headers;

    public CallResponseFrame(long id, byte flags, ResponseCode responseCode, Trace tracing, Map<String, String> headers, ChecksumType checksumType, int checksum, ByteBuf payload) {
        this.id = id;
        this.flags = flags;
        this.responseCode = responseCode;
        this.tracing = tracing;
        this.headers = headers;
        this.checksumType = checksumType;
        this.checksum = checksum;
        this.payload = payload;
    }

    public CallResponseFrame(long id, ResponseCode responseCode, Trace tracing, Map<String, String> headers, ChecksumType checksumType, int checksum) {
        this.id = id;
        this.responseCode = responseCode;
        this.tracing = tracing;
        this.headers = headers;
        this.checksumType = checksumType;
        this.checksum = checksum;
    }

    protected CallResponseFrame(long id) {
        this.id = id;
    }

    public boolean ok() {
        return this.responseCode == ResponseCode.OK;
    }

    @Override
    public boolean moreFragmentsFollow() {
        return (this.flags & 1) == 1;
    }

    @Override
    public FrameType getType() {
        return FrameType.CallResponse;
    }

    public Trace getTracing() {
        return this.tracing;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public ChecksumType getChecksumType() {
        return this.checksumType;
    }

    @Override
    public int getChecksum() {
        return this.checksum;
    }

    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    @Override
    public ByteBufHolder copy() {
        return new CallResponseFrame(this.id, this.flags, this.responseCode, this.tracing, this.headers, this.checksumType, this.checksum, this.payload.copy());
    }

    @Override
    public ByteBufHolder duplicate() {
        return new CallResponseFrame(this.id, this.flags, this.responseCode, this.tracing, this.headers, this.checksumType, this.checksum, this.payload.duplicate());
    }

    @Override
    public ByteBuf encodeHeader(ByteBufAllocator allocator) {
        ByteBuf buffer = allocator.buffer(1024);
        buffer.writeByte(this.getFlags());
        buffer.writeByte(this.getResponseCode().byteValue());
        CodecUtils.encodeTrace(this.getTracing(), buffer);
        CodecUtils.encodeSmallHeaders(this.getHeaders(), buffer);
        buffer.writeByte(this.getChecksumType().byteValue());
        CodecUtils.encodeChecksum(this.getChecksum(), this.getChecksumType(), buffer);
        return buffer;
    }

    @Override
    public void decode(TFrame tFrame) {
        this.flags = tFrame.payload.readByte();
        this.responseCode = ResponseCode.fromByte(tFrame.payload.readByte());
        this.tracing = CodecUtils.decodeTrace(tFrame.payload);
        this.headers = CodecUtils.decodeSmallHeaders(tFrame.payload);
        this.checksumType = ChecksumType.fromByte(tFrame.payload.readByte());
        this.checksum = CodecUtils.decodeChecksum(this.checksumType, tFrame.payload);
        int payloadSize = tFrame.size - tFrame.payload.readerIndex();
        this.payload = tFrame.payload.readSlice(payloadSize);
    }
}

