/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.handlers;

import com.uber.tchannel.channels.PeerManager;
import com.uber.tchannel.codecs.MessageCodec;
import com.uber.tchannel.errors.ErrorType;
import com.uber.tchannel.frames.ErrorFrame;
import com.uber.tchannel.frames.Frame;
import com.uber.tchannel.frames.InitRequestFrame;
import com.uber.tchannel.frames.InitResponseFrame;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;

public class InitRequestHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final PeerManager peerManager;

    public InitRequestHandler(PeerManager peerManager) {
        this.peerManager = peerManager;
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
        Frame frame = MessageCodec.decode(MessageCodec.decode(buf));
        switch (frame.getType()) {
            case InitRequest: {
                InitRequestFrame initRequestFrameMessage = (InitRequestFrame)frame;
                if (initRequestFrameMessage.getVersion() == 2) {
                    InitResponseFrame initResponseFrame = new InitResponseFrame(initRequestFrameMessage.getId(), 2);
                    initResponseFrame.setHostPort(this.peerManager.getHostPort());
                    initResponseFrame.setProcessName("java-process");
                    MessageCodec.write(ctx, initResponseFrame);
                    ctx.pipeline().remove(this);
                    this.peerManager.setIdentified(ctx.channel(), initRequestFrameMessage.getHeaders());
                    break;
                }
                ErrorFrame.sendError(ErrorType.FatalProtocolError, String.format("Expected Protocol version: %d, got version: %d", 2, initRequestFrameMessage.getVersion()), frame.getId(), ctx);
                break;
            }
            default: {
                ErrorFrame.sendError(ErrorType.FatalProtocolError, "The first frame should be an Init Request", frame.getId(), ctx);
            }
        }
    }
}

