/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.handlers;

import com.uber.tchannel.api.errors.TChannelError;
import com.uber.tchannel.api.errors.TChannelProtocol;
import com.uber.tchannel.channels.PeerManager;
import com.uber.tchannel.codecs.MessageCodec;
import com.uber.tchannel.frames.Frame;
import com.uber.tchannel.frames.InitResponseFrame;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;

public class InitRequestInitiator
extends SimpleChannelInboundHandler<ByteBuf> {
    private final PeerManager peerManager;

    public InitRequestInitiator(PeerManager peerManager) {
        this.peerManager = peerManager;
    }

    @Override
    protected void messageReceived(ChannelHandlerContext ctx, ByteBuf buf) throws TChannelError {
        Frame frame = MessageCodec.decode(MessageCodec.decode(buf));
        switch (frame.getType()) {
            case InitResponse: {
                InitResponseFrame initResponseFrameMessage = (InitResponseFrame)frame;
                if (initResponseFrameMessage.getVersion() == 2) {
                    ctx.pipeline().remove(this);
                    this.peerManager.setIdentified(ctx.channel(), initResponseFrameMessage.getHeaders());
                    break;
                }
                throw new TChannelProtocol(String.format("Expected Protocol version: %d, got version: %d", 2, initResponseFrameMessage.getVersion()));
            }
            default: {
                throw new TChannelProtocol("Frame recieved before Init Response");
            }
        }
    }
}

