/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.handlers;

import com.uber.tchannel.checksum.ChecksumType;
import com.uber.tchannel.codecs.MessageCodec;
import com.uber.tchannel.frames.CallFrame;
import com.uber.tchannel.frames.CallRequestContinueFrame;
import com.uber.tchannel.frames.CallRequestFrame;
import com.uber.tchannel.frames.CallResponseContinueFrame;
import com.uber.tchannel.frames.CallResponseFrame;
import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.messages.RawMessage;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.messages.Response;
import com.uber.tchannel.tracing.Trace;
import com.uber.tchannel.utils.TChannelUtilities;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.ArrayList;
import java.util.List;

public class MessageFragmenter
extends MessageToMessageEncoder<RawMessage> {
    @Override
    protected void encode(ChannelHandlerContext ctx, RawMessage msg, List<Object> out) throws Exception {
        this.writeFrames(ctx, msg, out);
        if (msg instanceof Response) {
            ((Response)msg).release();
        }
    }

    protected void writeFrames(ChannelHandlerContext ctx, RawMessage msg, List<Object> frames) throws Exception {
        ArrayList<ByteBuf> args = new ArrayList<ByteBuf>();
        args.add(msg.getArg1());
        args.add(msg.getArg2());
        args.add(msg.getArg3());
        CallFrame frame = null;
        while (!args.isEmpty()) {
            if (frame == null || frame.isPayloadFull()) {
                frame = this.createFrame(msg, args.size());
            }
            frame.encodePayload(ctx.alloc(), args);
            frames.add(MessageCodec.encode(ctx.alloc(), MessageCodec.encode(ctx.alloc(), frame)));
        }
    }

    protected CallFrame createFrame(RawMessage msg, int argCount) {
        if (msg.getType() == FrameType.CallRequest) {
            Request request = (Request)msg;
            if (argCount == 3) {
                return new CallRequestFrame(request.getId(), 0, request.getTTL(), new Trace(0L, 0L, 0L, 0), request.getService(), request.getTransportHeaders(), ChecksumType.NoChecksum, 0, TChannelUtilities.emptyByteBuf);
            }
            return new CallRequestContinueFrame(request.getId(), 0, ChecksumType.NoChecksum, 0, TChannelUtilities.emptyByteBuf);
        }
        Response response = (Response)msg;
        if (argCount == 3) {
            return new CallResponseFrame(response.getId(), 0, response.getResponseCode(), new Trace(0L, 0L, 0L, 0), response.getTransportHeaders(), ChecksumType.NoChecksum, 0, TChannelUtilities.emptyByteBuf);
        }
        return new CallResponseContinueFrame(response.getId(), 0, ChecksumType.NoChecksum, 0, TChannelUtilities.emptyByteBuf);
    }
}

