/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.headers;

public enum ArgScheme {
    RAW("raw"),
    JSON("json"),
    HTTP("http"),
    THRIFT("thrift"),
    STREAMING_THRIFT("sthrift");

    private final String scheme;

    private ArgScheme(String scheme) {
        this.scheme = scheme;
    }

    public static ArgScheme toScheme(String argScheme) {
        if (argScheme == null) {
            return null;
        }
        switch (argScheme) {
            case "raw": {
                return RAW;
            }
            case "json": {
                return JSON;
            }
            case "http": {
                return HTTP;
            }
            case "thrift": {
                return THRIFT;
            }
            case "sthrift": {
                return STREAMING_THRIFT;
            }
        }
        return null;
    }

    public static boolean isSupported(ArgScheme scheme) {
        if (scheme == null) {
            return false;
        }
        switch (scheme) {
            case RAW: 
            case JSON: 
            case THRIFT: {
                return true;
            }
        }
        return false;
    }

    public String getScheme() {
        return this.scheme;
    }
}

