/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.headers;

import java.util.HashSet;
import java.util.Set;

public enum RetryFlag {
    NoRetry('n'),
    RetryOnConnectionError('c'),
    RetryOnTimeout('t');

    private char flag;

    private RetryFlag(char flag) {
        this.flag = flag;
    }

    public static RetryFlag toRetryFlag(char c) {
        switch (c) {
            case 'n': {
                return NoRetry;
            }
            case 'c': {
                return RetryOnConnectionError;
            }
            case 't': {
                return RetryOnTimeout;
            }
        }
        return null;
    }

    public static Set<RetryFlag> parseFlags(String flags) {
        HashSet<RetryFlag> retryFlags = new HashSet<RetryFlag>();
        for (char c : flags.toCharArray()) {
            retryFlags.add(RetryFlag.toRetryFlag(c));
        }
        return retryFlags;
    }

    public static String flagsToString(Set<RetryFlag> flags) {
        StringBuilder sb = new StringBuilder();
        for (RetryFlag flag : flags) {
            sb.append(flag.toString());
        }
        return sb.toString();
    }

    public static boolean validFlags(String flags) {
        switch (flags) {
            case "c": 
            case "t": 
            case "n": 
            case "ct": 
            case "tc": {
                return true;
            }
        }
        return false;
    }

    public char getFlag() {
        return this.flag;
    }
}

