/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.JSONSerializer;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.messages.Serializer;
import com.uber.tchannel.messages.ThriftSerializer;
import com.uber.tchannel.utils.TChannelUtilities;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;

public abstract class EncodedRequest<T>
extends Request {
    private static final Serializer serializer = new Serializer((Map<ArgScheme, Serializer.SerializerInterface>)new HashMap<ArgScheme, Serializer.SerializerInterface>(){
        {
            this.put(ArgScheme.JSON, new JSONSerializer());
            this.put(ArgScheme.THRIFT, new ThriftSerializer());
        }
    });
    protected Map<String, String> headers;
    protected T body = null;

    protected EncodedRequest(Builder<T> builder) {
        super(builder);
        this.body = builder.body;
        this.headers = builder.headers;
    }

    protected EncodedRequest(long id, long ttl, String service, Map<String, String> transportHeaders, ByteBuf arg1, ByteBuf arg2, ByteBuf arg3) {
        super(id, ttl, service, transportHeaders, arg1, arg2, arg3);
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            if (this.arg2 != null) {
                this.headers = serializer.decodeHeaders(this);
            } else {
                return new HashMap<String, String>();
            }
        }
        return this.headers;
    }

    public String getHeader(String key) {
        return this.getHeaders().get(key);
    }

    public T getBody(Class<T> bodyType) {
        if (this.body == null) {
            if (this.arg3 != null) {
                this.body = serializer.decodeBody(this, bodyType);
            } else {
                return null;
            }
        }
        return this.body;
    }

    public static class Builder<T>
    extends Request.Builder {
        protected Map<String, String> headers = new HashMap<String, String>();
        protected T body = null;
        protected ArgScheme argScheme;

        public Builder(String service, String endpoint) {
            super(service, endpoint);
        }

        public Builder(String service, ByteBuf arg1) {
            super(service, arg1);
        }

        @Override
        public Builder<T> setArg2(ByteBuf arg2) {
            if (arg2 != null && !this.headers.isEmpty()) {
                throw new IllegalStateException("Cannot set both `arg2` and `headers`.");
            }
            super.setArg2(arg2);
            return this;
        }

        @Override
        public Builder<T> setArg3(ByteBuf arg3) {
            if (arg3 != null && this.body != null) {
                throw new IllegalStateException("Cannot set both `arg3` and `body`.");
            }
            super.setArg3(arg3);
            return this;
        }

        public Builder<T> setHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder<T> setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder<T> setBody(T body) {
            this.body = body;
            return this;
        }

        private Builder<T> validateHeader() {
            if (this.arg2 != null) {
                this.headers = null;
                return this;
            }
            this.arg2 = serializer.encodeHeaders(this.headers, this.argScheme);
            return this;
        }

        private Builder<T> validateBody() {
            if (this.arg3 != null) {
                this.body = null;
                return this;
            }
            this.arg3 = this.body == null ? TChannelUtilities.emptyByteBuf : serializer.encodeBody(this.body, this.argScheme);
            return this;
        }

        @Override
        public Builder<T> validate() {
            super.validate();
            this.validateHeader();
            this.validateBody();
            return this;
        }
    }
}

