/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.uber.tchannel.errors.ErrorType;
import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.messages.ResponseMessage;
import com.uber.tchannel.messages.TChannelMessage;

public final class ErrorResponse
extends ResponseMessage
implements TChannelMessage {
    private final ErrorType errorType;
    private final String message;
    private final long id;
    private Throwable throwable;

    public ErrorResponse(long id, ErrorType errorType, String message) {
        this.id = id;
        this.errorType = errorType;
        this.message = message;
        this.type = FrameType.Error;
        this.throwable = null;
    }

    public ErrorResponse(long id, ErrorType errorType, Throwable throwable) {
        this(id, errorType, throwable.getMessage());
        this.throwable = throwable;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public FrameType getType() {
        return super.getType();
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.format("<%s id=%s errorType=%s message=%s>", new Object[]{this.getClass().getSimpleName(), this.id, this.errorType, this.message});
    }

    @Override
    public void release() {
    }
}

