/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.uber.tchannel.messages.Serializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public final class JSONSerializer
implements Serializer.SerializerInterface {
    private static final Type HEADER_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Gson GSON = new Gson();

    @Override
    public String decodeEndpoint(ByteBuf arg1) {
        String endpoint = arg1.toString(CharsetUtil.UTF_8);
        return endpoint;
    }

    @Override
    public Map<String, String> decodeHeaders(ByteBuf arg2) {
        String headerJSON = arg2.toString(CharsetUtil.UTF_8);
        Map headers = null;
        if (headerJSON != null && !headerJSON.isEmpty() && !headerJSON.equals("\"\"")) {
            headers = (Map)new Gson().fromJson(headerJSON, HEADER_TYPE);
        }
        return headers == null ? new HashMap() : headers;
    }

    @Override
    public <T> T decodeBody(ByteBuf arg3, Class<T> bodyType) {
        String bodyJSON = arg3.toString(CharsetUtil.UTF_8);
        return GSON.fromJson(bodyJSON, bodyType);
    }

    @Override
    public ByteBuf encodeEndpoint(String method) {
        return Unpooled.wrappedBuffer(method.getBytes());
    }

    @Override
    public ByteBuf encodeHeaders(Map<String, String> applicationHeaders) {
        return Unpooled.wrappedBuffer(GSON.toJson(applicationHeaders, HEADER_TYPE).getBytes());
    }

    @Override
    public ByteBuf encodeBody(Object body) {
        return Unpooled.wrappedBuffer(GSON.toJson(body).getBytes());
    }
}

